/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class TFCFox
extends Fox {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID_TFC = SynchedEntityData.defineId(TFCFox.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public TFCFox(EntityType<? extends Fox> type, Level level) {
        super(type, level);
    }

    protected void populateDefaultEquipmentSlots(RandomSource source, DifficultyInstance instance) {
        if (this.random.nextFloat() < 0.15f) {
            Helpers.randomItem(TFCTags.Items.FOX_SPAWNS_WITH, this.random).ifPresent(item -> this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item)));
        }
    }

    public Fox.Type getVariant() {
        return Fox.Type.byId((int)((Integer)this.entityData.get(DATA_TYPE_ID_TFC)));
    }

    public void setVariant(Fox.Type id) {
        this.entityData.set(DATA_TYPE_ID_TFC, (Object)id.getId());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID_TFC, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 3);
        EntityHelpers.removeGoalOfClass(this.goalSelector, Fox.FoxEatBerriesGoal.class);
        this.goalSelector.addGoal(4, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 1.6f, 1.4f, TFCTags.Entities.HUNTS_LAND_PREY));
        this.goalSelector.addGoal(10, (Goal)new TFCFoxEatBerriesGoal());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        BlockPos pos = this.blockPosition();
        ChunkData chunkData = ChunkData.get((LevelReader)level, pos);
        this.setVariant(chunkData.getAverageSeaLevelTemp(this.blockPosition()) < 0.0f ? Fox.Type.SNOW : Fox.Type.RED);
        return spawnData;
    }

    public TFCFox getBreedOffspring(ServerLevel level, AgeableMob other) {
        TFCFox fox = (TFCFox)((EntityType)TFCEntities.FOX.get()).create((Level)level);
        this.setVariant(this.random.nextBoolean() ? this.getVariant() : ((TFCFox)other).getVariant());
        return fox;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public class TFCFoxEatBerriesGoal
    extends Fox.FoxEatBerriesGoal {
        public TFCFoxEatBerriesGoal() {
            super((Fox)TFCFox.this, 1.2, 12, 1);
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            return Helpers.isBlock(state, TFCTags.Blocks.FOX_RAIDABLE) && this.isFruiting(state);
        }

        protected void onReachedTarget() {
            BlockState currentState;
            Block block;
            TFCFox fox = TFCFox.this;
            Level level = fox.level();
            if (EventHooks.canEntityGrief((Level)level, (Entity)fox) && (block = (currentState = level.getBlockState(this.blockPos)).getBlock()) instanceof SeasonalPlantBlock) {
                ItemStack product;
                SeasonalPlantBlock seasonal = (SeasonalPlantBlock)block;
                if (fox.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty() && !(product = seasonal.getProductItem(fox.random)).isEmpty()) {
                    fox.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
                    product.setCount(1);
                    fox.setItemSlot(EquipmentSlot.MAINHAND, product);
                    level.setBlockAndUpdate(this.blockPos, seasonal.stateAfterPicking(currentState));
                }
            }
        }

        public boolean canUse() {
            return super.canUse() && TFCFox.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
        }

        private boolean isFruiting(BlockState state) {
            return state.hasProperty(SeasonalPlantBlock.LIFECYCLE) && state.getValue(SeasonalPlantBlock.LIFECYCLE) == Lifecycle.FRUITING;
        }
    }
}

