/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TFCPanda
extends Panda {
    public TFCPanda(EntityType<? extends Panda> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityHelpers.removeGoalOfPriority(this.goalSelector, 2);
        this.goalSelector.addGoal(6, (Goal)new PandaAvoidGoal(this));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        Panda panda = (Panda)((EntityType)TFCEntities.PANDA.get()).create((Level)level);
        if (panda != null) {
            if (parent instanceof Panda) {
                Panda pandaParent = (Panda)parent;
                panda.setGeneFromParents((Panda)this, pandaParent);
            }
            panda.setAttributes();
        }
        return panda;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isFood(player.getItemInHand(hand)) && this.isBaby()) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean canFallInLove() {
        return false;
    }

    public static class PandaAvoidGoal
    extends TFCAvoidEntityGoal<PathfinderMob> {
        private final Panda panda;

        public PandaAvoidGoal(Panda panda) {
            super((PathfinderMob)panda, PathfinderMob.class, 8.0f, 2.0, 2.0, TFCTags.Entities.HUNTS_LAND_PREY);
            this.panda = panda;
        }

        @Override
        public boolean canUse() {
            return this.panda.isWorried() && this.panda.canPerformAction() && super.canUse();
        }
    }
}

