/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class WildAnimal
extends AgeableMob
implements GenderedRenderAnimal {
    public static final EntityDataAccessor<Boolean> DATA_IS_MALE = SynchedEntityData.defineId(WildAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_BABY = SynchedEntityData.defineId(WildAnimal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected final Supplier<SoundEvent> ambient;
    protected final Supplier<SoundEvent> death;
    protected final Supplier<SoundEvent> hurt;
    protected final Supplier<SoundEvent> step;

    public WildAnimal(EntityType<? extends AgeableMob> type, Level level, TFCSounds.EntityId sounds) {
        super(type, level);
        this.ambient = sounds.ambient();
        this.death = sounds.death();
        this.hurt = sounds.hurt();
        this.step = sounds.step();
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 4000L == 0L && this.random.nextInt(2000) == 0) {
            this.setBaby(false);
        }
    }

    @Override
    public boolean displayMaleCharacteristics() {
        return this.isMale() && !this.isBaby();
    }

    @Override
    public boolean displayFemaleCharacteristics() {
        return !this.isMale();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_MALE, (Object)true);
        builder.define(DATA_IS_BABY, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_IS_BABY.equals(key)) {
            this.refreshDimensions();
        }
    }

    public boolean isMale() {
        return (Boolean)this.entityData.get(DATA_IS_MALE);
    }

    public void setIsMale(boolean male) {
        this.entityData.set(DATA_IS_MALE, (Object)male);
    }

    public boolean isBaby() {
        return (Boolean)this.entityData.get(DATA_IS_BABY);
    }

    public void setBaby(boolean baby) {
        this.entityData.set(DATA_IS_BABY, (Object)baby);
    }

    public void setAge(int age) {
        super.setAge(0);
    }

    public int getAge() {
        return this.isBaby() ? -24000 : 0;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        this.setIsMale(level.getRandom().nextBoolean());
        this.setBaby(this.random.nextFloat() < 0.1f);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnData);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("male", this.isMale());
        tag.putBoolean("baby", this.isBaby());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setIsMale(tag.getBoolean("male"));
        this.setBaby(tag.getBoolean("baby"));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)this.getType().create((Level)level);
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        this.playSound(this.step.get(), 0.15f, 1.0f);
    }

    protected SoundEvent getHurtSound(DamageSource src) {
        return this.hurt.get();
    }

    protected SoundEvent getDeathSound() {
        return this.death.get();
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public boolean canBeLeashed() {
        return Helpers.isEntity((Entity)this, TFCTags.Entities.LEASHABLE_WILD_ANIMALS);
    }

    protected PathNavigation createNavigation(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.getPathfindingCostFromLightLevels(pos) - 0.5f;
    }
}

