/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import org.jetbrains.annotations.Nullable;

public abstract class MoltenFluid
extends BaseFlowingFluid {
    private final LavaFluid lava = (LavaFluid)Fluids.LAVA;

    protected MoltenFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    protected void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        this.lava.animateTick(worldIn, pos, state, random);
    }

    protected void randomTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        this.lava.randomTick(worldIn, pos, state, random);
    }

    @Nullable
    protected ParticleOptions getDripParticle() {
        return this.lava.getDripParticle();
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    protected void beforeDestroyingBlock(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        worldIn.levelEvent(1501, pos, 0);
    }

    protected int getSlopeFindDistance(LevelReader worldIn) {
        return this.lava.getSlopeFindDistance(worldIn);
    }

    protected int getDropOff(LevelReader worldIn) {
        return this.lava.getDropOff(worldIn);
    }

    public int getTickDelay(LevelReader world) {
        return this.lava.getTickDelay(world);
    }

    protected int getSpreadDelay(Level worldIn, BlockPos pos, FluidState fluidState_, FluidState fluidState1_) {
        return this.lava.getSpreadDelay(worldIn, pos, fluidState_, fluidState1_);
    }

    public static class Source
    extends MoltenFluid {
        public Source(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        public int getAmount(FluidState state) {
            return 8;
        }
    }

    public static class Flowing
    extends MoltenFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean isSource(FluidState state) {
            return false;
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder.add(new Property[]{LEVEL}));
        }
    }
}

