/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FlowingFluidExtension;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class RiverWaterFluid
extends WaterFluid
implements FlowingFluidExtension {
    public static final EnumProperty<Flow> FLOW = TFCBlockStateProperties.FLOW;

    private static boolean isSameAbove(FluidState fluid, BlockGetter level, BlockPos pos) {
        return fluid.getType().isSame(level.getFluidState(pos.above()).getType());
    }

    public boolean isSource(FluidState state) {
        return true;
    }

    public boolean isSame(Fluid fluid) {
        return super.isSame(fluid) || fluid == TFCFluids.RIVER_WATER.get() || fluid == TFCFluids.SALT_WATER.getSource() || fluid == TFCFluids.SALT_WATER.getFlowing() || fluid == Fluids.WATER || fluid == Fluids.FLOWING_WATER;
    }

    public FluidType getFluidType() {
        return (FluidType)NeoForgeMod.WATER_TYPE.value();
    }

    public float getHeight(FluidState fluid, BlockGetter level, BlockPos pos) {
        return RiverWaterFluid.isSameAbove(fluid, level, pos) ? 1.0f : this.getOwnHeight(fluid);
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((RiverWaterBlock)TFCBlocks.RIVER_WATER.get()).defaultBlockState().setValue(FLOW, (Comparable)((Object)((Flow)((Object)state.getValue(FLOW)))));
    }

    @Override
    public FluidState getSource(LevelReader level, BlockPos pos, boolean falling) {
        Flow flow = Flow.lerp(this.getFlowFromDirection(level, pos, Direction.NORTH), this.getFlowFromDirection(level, pos, Direction.EAST), this.getFlowFromDirection(level, pos, Direction.WEST), this.getFlowFromDirection(level, pos, Direction.SOUTH), 0.5f, 0.5f);
        if (flow == Flow.NONE) {
            return this.getSource(falling);
        }
        return (FluidState)((FluidState)((RiverWaterFluid)TFCFluids.RIVER_WATER.get()).defaultFluidState().setValue((Property)BlockStateProperties.FALLING, (Comparable)Boolean.valueOf(falling))).setValue(FLOW, (Comparable)((Object)flow));
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.createFluidStateDefinition(builder.add(new Property[]{FLOW}));
    }

    public Vec3 getFlow(BlockGetter level, BlockPos pos, FluidState fluid) {
        Flow flow = (Flow)((Object)fluid.getValue(FLOW));
        Vec3 vector = flow.getVector();
        if (((Boolean)fluid.getValue((Property)FALLING)).booleanValue()) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                cursor.setWithOffset((Vec3i)pos, direction);
                if (!this.isSolidFace(level, (BlockPos)cursor, direction) && !this.isSolidFace(level, cursor.above(), direction)) continue;
                vector = vector.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vector.normalize();
    }

    public int getAmount(FluidState state) {
        return 8;
    }

    private Flow getFlowFromDirection(LevelReader level, BlockPos pos, Direction direction) {
        FluidState adjacentFluid = level.getFluidState(pos.relative(direction));
        if (adjacentFluid.hasProperty(TFCBlockStateProperties.FLOW)) {
            return (Flow)((Object)adjacentFluid.getValue(TFCBlockStateProperties.FLOW));
        }
        return Flow.NONE;
    }
}

