/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHolder;
import net.dries007.tfc.common.fluids.FluidId;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.MoltenFluid;
import net.dries007.tfc.common.fluids.RiverWaterFluid;
import net.dries007.tfc.common.fluids.SimpleFluid;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class TFCFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"tfc");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"tfc");
    public static final int ALPHA_MASK = -16777216;
    public static final Map<Metal, FluidHolder<BaseFlowingFluid>> METALS = Helpers.mapOf(Metal.class, metal -> TFCFluids.register("metal/" + metal.getSerializedName(), properties -> properties.block((Supplier)TFCBlocks.METAL_FLUIDS.get(metal)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(metal))).explosionResistance(100.0f), TFCFluids.lavaLike().descriptionId("fluid.tfc.metal." + metal.getSerializedName()).rarity(metal.rarity()), MoltenFluid.Source::new, MoltenFluid.Flowing::new));
    public static final FluidHolder<BaseFlowingFluid> SALT_WATER = TFCFluids.register("salt_water", properties -> properties.block(TFCBlocks.SALT_WATER).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.SALT_WATER)), TFCFluids.waterLike().descriptionId("fluid.tfc.salt_water"), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final FluidHolder<BaseFlowingFluid> SPRING_WATER = TFCFluids.register("spring_water", properties -> properties.block(TFCBlocks.SPRING_WATER).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.SPRING_WATER)), TFCFluids.waterLike().descriptionId("fluid.tfc.spring_water"), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final DeferredHolder<Fluid, RiverWaterFluid> RIVER_WATER = FLUIDS.register("river_water", RiverWaterFluid::new);
    public static final Map<SimpleFluid, FluidHolder<BaseFlowingFluid>> SIMPLE_FLUIDS = Helpers.mapOf(SimpleFluid.class, fluid -> TFCFluids.register(fluid.getId(), properties -> properties.block((Supplier)TFCBlocks.SIMPLE_FLUIDS.get(fluid)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(fluid))), TFCFluids.waterLike().descriptionId("fluid.tfc." + fluid.getId()).canConvertToSource(false), MixingFluid.Source::new, MixingFluid.Flowing::new));
    public static final Map<DyeColor, FluidHolder<BaseFlowingFluid>> COLORED_FLUIDS = Helpers.mapOf(DyeColor.class, color -> TFCFluids.register(color.getName() + "_dye", properties -> properties.block((Supplier)TFCBlocks.COLORED_FLUIDS.get(color)).bucket((Supplier)TFCItems.FLUID_BUCKETS.get(FluidId.asType(color))), TFCFluids.waterLike().descriptionId("fluid.tfc." + color.getName() + "_dye").canConvertToSource(false), MixingFluid.Source::new, MixingFluid.Flowing::new));

    private static FluidType.Properties lavaLike() {
        return FluidType.Properties.create().adjacentPathType(PathType.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(3000).viscosity(6000).temperature(1300).canConvertToSource(false).canDrown(false).canExtinguish(false).canHydrate(false).canPushEntity(false).canSwim(false).supportsBoating(false);
    }

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(PathType.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(true).canPushEntity(true).canSwim(true).supportsBoating(true);
    }

    private static <F extends FlowingFluid> FluidHolder<F> register(String name, Consumer<BaseFlowingFluid.Properties> builder, FluidType.Properties typeProperties, Function<BaseFlowingFluid.Properties, F> sourceFactory, Function<BaseFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid(FLUID_TYPES, FLUIDS, name, name, flowingName, builder, () -> new FluidType(typeProperties), sourceFactory, flowingFactory);
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(SALT_WATER.getType(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(SPRING_WATER.getType(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
    }
}

