/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.Objects;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.Rackable;
import net.dries007.tfc.common.items.TooltipBlockItem;
import net.dries007.tfc.util.BlockItemPlacement;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockItem
extends TooltipBlockItem
implements Rackable {
    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResult result = this.tryInteractWithFluid(level, player, hand);
        if (result != InteractionResult.PASS) {
            return new InteractionResultHolder(result, (Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result;
        Player player = context.getPlayer();
        if (player != null && (result = this.tryInteractWithFluid(context.getLevel(), player, context.getHand())) != InteractionResult.PASS) {
            return result;
        }
        return super.useOn(context);
    }

    @Override
    public boolean useOnRack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item = player.getItemInHand(hand);
        Item item2 = item.getItem();
        if (item2 instanceof BarrelBlockItem) {
            BarrelBlockItem blockItem = (BarrelBlockItem)item2;
            BlockState barrelState = (BlockState)((BlockState)((BlockState)blockItem.getStateForPlacement((LevelAccessor)level, pos).setValue(BarrelBlock.FACING, (Comparable)player.getDirection().getOpposite())).setValue((Property)BarrelBlock.RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)BarrelBlock.SEALED, (Comparable)Boolean.valueOf(true));
            barrelState = BlockItemPlacement.updateBlockStateFromTag(pos, level, item, barrelState);
            level.setBlockAndUpdate(pos, barrelState);
            Objects.requireNonNull(level.getBlockEntity(pos)).applyComponentsFromItemStack(item);
            if (!player.isCreative()) {
                item.shrink(1);
            }
            Helpers.playPlaceSound(player, (LevelAccessor)level, pos, state);
            return true;
        }
        return false;
    }

    private InteractionResult tryInteractWithFluid(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        @Nullable IFluidHandler handler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return InteractionResult.PASS;
        }
        BlockHitResult hit = BarrelBlockItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (FluidHelpers.transferBetweenWorldAndItem(stack, level, hit, player, hand, false, false, true)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return this.getDefaultInstance();
    }

    public BlockState getStateForPlacement(LevelAccessor level, BlockPos pos) {
        return ((SealableDeviceBlock)this.getBlock()).getStateForPlacement(level, pos);
    }
}

