/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class CandleBlockItem
extends BlockItem {
    private final Supplier<? extends Block> candleCakeBlock;

    public CandleBlockItem(Item.Properties properties, Block block, Supplier<? extends Block> candleCakeBlock) {
        super(block, properties);
        this.candleCakeBlock = candleCakeBlock;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        ItemStack held = context.getItemInHand();
        if (Helpers.isBlock(state, (Block)TFCBlocks.CAKE.get())) {
            Item item = held.getItem();
            if (state.hasProperty((Property)CakeBlock.BITES) && (Integer)state.getValue((Property)CakeBlock.BITES) == 0) {
                if (player != null && !player.isCreative()) {
                    held.shrink(1);
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                }
                level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlockAndUpdate(pos, this.candleCakeBlock.get().defaultBlockState());
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useOn(context);
    }
}

