/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FirestarterItem
extends Item {
    public FirestarterItem(Item.Properties properties) {
        super(properties);
    }

    public void onUseTick(Level level, LivingEntity livingEntityIn, ItemStack stack, int countLeft) {
        if (livingEntityIn instanceof Player) {
            Player player = (Player)livingEntityIn;
            BlockHitResult result = FirestarterItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            BlockPos pos = result.getBlockPos();
            BlockPos abovePos = pos.above();
            double chance = TFCConfig.SERVER.fireStarterChance.get() * (level.isRainingAt(abovePos) ? 0.3 : 1.0);
            if (level.isClientSide()) {
                Vec3 location = result.getLocation();
                this.makeEffects(level, player, location.x(), location.y(), location.z(), countLeft, this.getUseDuration(stack, (LivingEntity)player), level.random);
            } else if (countLeft == 1) {
                if (!player.isCreative()) {
                    Helpers.damageItem(stack, (LivingEntity)player, InteractionHand.MAIN_HAND);
                }
                if (StartFireEvent.startFire(level, pos, level.getBlockState(pos), result.getDirection(), player, stack, StartFireEvent.FireStrength.STRONG, chance)) {
                    player.stopUsingItem();
                }
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72;
    }

    private void makeEffects(Level world, Player player, double x, double y, double z, int countLeft, int total, RandomSource random) {
        int count = total - countLeft;
        if ((double)random.nextFloat() + 0.3 < (double)count / (double)total) {
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, (double)0.1f, 0.0);
        }
        if (countLeft < 10 && (double)random.nextFloat() + 0.3 < (double)count / (double)total) {
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, (double)0.1f, 0.0);
        }
        if (count % 3 == 1) {
            player.playSound((SoundEvent)TFCSounds.FIRESTARTER.get(), 0.5f, 0.05f);
        }
    }
}

