/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidContainerItem
extends Item {
    protected final FluidContainerInfo containerInfo;
    private final boolean canPlaceLiquidsInWorld;
    private final Supplier<Boolean> canPlaceSourceBlocks;

    protected FluidContainerItem(Item.Properties properties, final Supplier<Integer> capacity, final TagKey<Fluid> whitelist, boolean canPlaceLiquidsInWorld, Supplier<Boolean> canPlaceSourceBlocks) {
        super(properties.component(TFCComponents.FLUID, (Object)FluidComponent.EMPTY));
        this.canPlaceLiquidsInWorld = canPlaceLiquidsInWorld;
        this.canPlaceSourceBlocks = canPlaceSourceBlocks;
        this.containerInfo = new FluidContainerInfo(){

            @Override
            public boolean canContainFluid(Fluid input) {
                return Helpers.isFluid(input, (TagKey<Fluid>)whitelist);
            }

            @Override
            public int fluidCapacity() {
                return (Integer)capacity.get();
            }
        };
    }

    public FluidContainerInfo containerInfo() {
        return this.containerInfo;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult hit;
        ItemStack stack = player.getItemInHand(hand);
        if (FluidHelpers.transferBetweenWorldAndItem(stack, level, hit = FluidContainerItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY), player, hand, this.canPlaceLiquidsInWorld, this.canPlaceSourceBlocks(), false)) {
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        @Nullable IFluidHandler handler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (handler.getFluidInTank(0).isEmpty()) {
            return this.afterFillFailed(handler, level, player, stack, hand);
        }
        return this.afterEmptyFailed(handler, level, player, stack, hand);
    }

    public Component getName(ItemStack stack) {
        FluidStack fluid = FluidHelpers.getContainedFluid(stack);
        if (!fluid.isEmpty()) {
            return Component.translatable((String)(this.getDescriptionId(stack) + ".filled"), (Object[])new Object[]{fluid.getHoverName()});
        }
        return super.getName(stack);
    }

    public int getMaxStackSize(ItemStack stack) {
        return FluidHelpers.getContainedFluid(stack.copyWithCount(1)).isEmpty() ? super.getMaxStackSize(stack) : 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        FluidStack fluid = FluidHelpers.getContainedFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)Tooltips.fluidUnitsAndCapacityOf(fluid, this.containerInfo.fluidCapacity()));
        }
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)this);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !FluidHelpers.getContainedFluid(stack).isEmpty();
    }

    public boolean canPlaceSourceBlocks() {
        return this.canPlaceSourceBlocks.get();
    }

    public boolean canPlaceLiquidsInWorld() {
        return this.canPlaceLiquidsInWorld;
    }

    protected InteractionResultHolder<ItemStack> afterFillFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResultHolder.pass((Object)stack);
    }

    protected InteractionResultHolder<ItemStack> afterEmptyFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        return InteractionResultHolder.pass((Object)stack);
    }
}

