/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.GlassBasinBlockEntity;
import net.dries007.tfc.common.blockentities.HotPouredGlassBlockEntity;
import net.dries007.tfc.common.blocks.GlassBasinBlock;
import net.dries007.tfc.common.blocks.HotPouredGlassBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.component.glass.GlassWorking;
import net.dries007.tfc.common.items.BlowpipeItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class GlassBlowpipeItem
extends BlowpipeItem {
    private final float breakChance;

    private static ItemStack getOtherHandItem(Player player) {
        return player.getItemInHand(player.getUsedItemHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }

    private static ItemStack getOtherHandItem(Player player, InteractionHand hand) {
        return player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
    }

    public GlassBlowpipeItem(Item.Properties properties, float breakChance) {
        super(properties);
        this.breakChance = breakChance;
    }

    public InteractionResult useOn(UseOnContext context) {
        GlassworkingRecipe recipe;
        ItemStack copy;
        ItemStack item;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Direction face = context.getClickedFace();
        Player player = context.getPlayer();
        BlockPos center = pos.relative(face);
        if (GlassBasinBlock.isValid(level, center) && player != null) {
            item = context.getItemInHand();
            copy = item.copy();
            GlassWorking.apply(copy, (GlassOperation)GlassOperation.BASIN_POUR.value());
            recipe = GlassworkingRecipe.get(level, copy);
            if (recipe != null) {
                if (!((GlassOperation)GlassOperation.BASIN_POUR.value()).hasRequiredTemperature(copy)) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.glass.not_hot_enough"), true);
                } else {
                    this.consumeBlowpipe(player, context.getHand(), item);
                    level.setBlockAndUpdate(center, ((Block)TFCBlocks.GLASS_BASIN.get()).defaultBlockState());
                    BlockEntity blockEntity = level.getBlockEntity(center);
                    if (blockEntity instanceof GlassBasinBlockEntity) {
                        GlassBasinBlockEntity glass = (GlassBasinBlockEntity)blockEntity;
                        glass.setGlassItem(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer server = (ServerPlayer)player;
                        TFCAdvancements.BASIN_POUR.trigger(server);
                    }
                    return InteractionResult.CONSUME;
                }
            }
        }
        if (face == Direction.UP && Helpers.isBlock(state, TFCTags.Blocks.GLASS_POURING_TABLE) && level.getBlockState(pos.above()).isAir() && player != null) {
            item = context.getItemInHand();
            copy = item.copy();
            GlassWorking.apply(copy, (GlassOperation)GlassOperation.TABLE_POUR.value());
            recipe = GlassworkingRecipe.get(level, copy);
            if (recipe != null) {
                if (!((GlassOperation)GlassOperation.TABLE_POUR.value()).hasRequiredTemperature(copy)) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.glass.not_hot_enough"), true);
                } else {
                    this.consumeBlowpipe(player, context.getHand(), item);
                    level.setBlockAndUpdate(pos.above(), (BlockState)((Block)TFCBlocks.HOT_POURED_GLASS.get()).defaultBlockState().setValue((Property)HotPouredGlassBlock.FLAT, (Comparable)Boolean.valueOf(false)));
                    BlockEntity blockEntity = level.getBlockEntity(pos.above());
                    if (blockEntity instanceof HotPouredGlassBlockEntity) {
                        HotPouredGlassBlockEntity glass = (HotPouredGlassBlockEntity)blockEntity;
                        glass.setGlassItem(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer server = (ServerPlayer)player;
                        TFCAdvancements.TABLE_POUR.trigger(server);
                    }
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean consumeBlowpipe(Player player, InteractionHand hand, ItemStack item) {
        boolean broken = player.getRandom().nextFloat() < this.breakChance;
        player.setItemInHand(hand, broken ? ItemStack.EMPTY : BlowpipeItem.transform(item.getItem()).getDefaultInstance());
        return broken;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        ItemStack otherItem = GlassBlowpipeItem.getOtherHandItem(player, hand);
        GlassOperation op = GlassOperation.get(otherItem, player);
        if (op != null) {
            if (!op.hasRequiredTemperature(held)) {
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.glass.not_hot_enough"), true);
                return InteractionResultHolder.fail((Object)held);
            }
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)held);
        }
        return InteractionResultHolder.pass((Object)held);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int ticksLeft) {
        Player player;
        GlassOperation op;
        if (ticksLeft % 30 == 0 && entity instanceof Player && (op = GlassOperation.get(GlassBlowpipeItem.getOtherHandItem(player = (Player)entity), player)) != null) {
            level.playSound(null, entity.blockPosition(), op.getSound(), SoundSource.PLAYERS, 1.0f, 0.8f + (float)(player.getLookAngle().y / 2.0));
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide) {
                ItemStack otherHand = GlassBlowpipeItem.getOtherHandItem(player);
                GlassOperation op = GlassOperation.get(otherHand, player);
                if (op != null && stack.getItem() instanceof GlassBlowpipeItem) {
                    GlassWorking.apply(stack, op);
                    @Nullable GlassworkingRecipe recipe = GlassworkingRecipe.get(level, stack);
                    if (recipe != null) {
                        boolean broken = this.consumeBlowpipe(player, player.getUsedItemHand(), stack);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy());
                        level.playSound(null, player.blockPosition(), broken ? SoundEvents.ITEM_BREAK : SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                player.getCooldowns().addCooldown(TFCItems.BLOWPIPE.asItem(), 80);
                player.getCooldowns().addCooldown(TFCItems.CERAMIC_BLOWPIPE.asItem(), 80);
                player.getCooldowns().addCooldown(TFCItems.BLOWPIPE_WITH_GLASS.asItem(), 80);
                player.getCooldowns().addCooldown(TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.asItem(), 80);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }
}

