/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.util.data.Drinkable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class GlassBottleItem
extends FluidContainerItem {
    public static final int DRINK_AMOUNT = 100;
    private final Supplier<Double> breakChance;

    public GlassBottleItem(Item.Properties properties, Supplier<Integer> capacity, Supplier<Double> breakChance, TagKey<Fluid> whitelist) {
        super(properties, capacity, whitelist, false, () -> false);
        this.breakChance = breakChance;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        @Nullable IFluidHandler handler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            FluidStack drained = handler.drain(100, IFluidHandler.FluidAction.EXECUTE);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Drinkable drinkable = Drinkable.get(drained.getFluid());
                if (drinkable != null && !level.isClientSide) {
                    drinkable.onDrink(player, drained.getAmount());
                }
            }
            if ((double)entity.getRandom().nextFloat() < this.breakChance.get()) {
                stack.shrink(1);
                level.playSound(null, entity.blockPosition(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return stack;
    }

    @Override
    protected InteractionResultHolder<ItemStack> afterFillFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        level.playSound(player, player.blockPosition(), (SoundEvent)TFCSounds.JUG_BLOW.get(), SoundSource.PLAYERS, 1.0f, 1.3f + (float)(player.getLookAngle().y / 2.0));
        return InteractionResultHolder.success((Object)stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @Override
    protected InteractionResultHolder<ItemStack> afterEmptyFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            level.playSound(player, player.blockPosition(), SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 0.5f, 1.2f);
            handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResultHolder.consume((Object)stack);
        }
        Drinkable drinkable = Drinkable.get(handler.getFluidInTank(0).getFluid());
        if (drinkable != null) {
            if (!drinkable.mayDrinkWhenFull() && IPlayerInfo.get(player).getThirst() >= 100.0f) {
                return InteractionResultHolder.fail((Object)stack);
            }
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public int getBarColor(ItemStack stack) {
        FluidStack fluid = FluidHelpers.getContainedFluid(stack);
        if (!fluid.isEmpty()) {
            int color = RenderHelpers.getFluidColor(fluid);
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            return FastColor.ARGB32.color((int)0, (int)r, (int)g, (int)b);
        }
        return 1048575;
    }

    public int getBarWidth(ItemStack stack) {
        FluidStack fluid = FluidHelpers.getContainedFluid(stack);
        return fluid.isEmpty() ? 0 : (int)Mth.clamp((float)((float)fluid.getAmount() / (float)this.containerInfo.fluidCapacity() * 13.0f), (float)1.0f, (float)13.0f);
    }

    public boolean isBarVisible(ItemStack stack) {
        return !FluidHelpers.getContainedFluid(stack).isEmpty();
    }
}

