/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.data.LampFuel;
import net.dries007.tfc.util.loot.CopyFluidFunction;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class LampBlockItem
extends BlockItem {
    private final FluidContainerInfo containerInfo;

    public LampBlockItem(final Block block, Item.Properties properties) {
        super(block, properties);
        this.containerInfo = new FluidContainerInfo(){

            @Override
            public boolean canContainFluid(Fluid input) {
                return LampFuel.get(input, block.defaultBlockState()) != null;
            }

            @Override
            public int fluidCapacity() {
                return TFCConfig.SERVER.lampCapacity.get();
            }
        };
    }

    public FluidContainerInfo containerInfo() {
        return this.containerInfo;
    }

    public String getDescriptionId(ItemStack stack) {
        return FluidHelpers.getContainedFluid(stack).isEmpty() ? super.getDescriptionId(stack) : super.getDescriptionId(stack) + ".filled";
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        boolean flag = super.updateCustomBlockEntityTag(pos, level, player, stack, state);
        CopyFluidFunction.copyFromItem(stack, level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).orElse(null));
        return flag;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        FluidStack fluid = FluidHelpers.getContainedFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)Tooltips.fluidUnitsOf(fluid));
        }
    }
}

