/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.component.heat.HeatComponent;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.data.FluidHeat;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MoldItem
extends Item {
    private final FluidContainerInfo containerInfo;

    private static Supplier<Integer> mapItemTypeToConfigValue(Metal.ItemType type) {
        return switch (type) {
            case Metal.ItemType.INGOT -> TFCConfig.SERVER.moldIngotCapacity;
            case Metal.ItemType.PICKAXE_HEAD -> TFCConfig.SERVER.moldPickaxeHeadCapacity;
            case Metal.ItemType.PROPICK_HEAD -> TFCConfig.SERVER.moldPropickHeadCapacity;
            case Metal.ItemType.AXE_HEAD -> TFCConfig.SERVER.moldAxeHeadCapacity;
            case Metal.ItemType.SHOVEL_HEAD -> TFCConfig.SERVER.moldShovelHeadCapacity;
            case Metal.ItemType.HOE_HEAD -> TFCConfig.SERVER.moldHoeHeadCapacity;
            case Metal.ItemType.CHISEL_HEAD -> TFCConfig.SERVER.moldChiselHeadCapacity;
            case Metal.ItemType.HAMMER_HEAD -> TFCConfig.SERVER.moldHammerHeadCapacity;
            case Metal.ItemType.SAW_BLADE -> TFCConfig.SERVER.moldSawBladeCapacity;
            case Metal.ItemType.JAVELIN_HEAD -> TFCConfig.SERVER.moldJavelinHeadCapacity;
            case Metal.ItemType.SWORD_BLADE -> TFCConfig.SERVER.moldSwordBladeCapacity;
            case Metal.ItemType.MACE_HEAD -> TFCConfig.SERVER.moldMaceHeadCapacity;
            case Metal.ItemType.KNIFE_BLADE -> TFCConfig.SERVER.moldKnifeBladeCapacity;
            case Metal.ItemType.SCYTHE_BLADE -> TFCConfig.SERVER.moldScytheBladeCapacity;
            default -> throw new AssertionError((Object)("No config value for type: " + type.name()));
        };
    }

    public MoldItem(Metal.ItemType type, Item.Properties properties) {
        this(MoldItem.mapItemTypeToConfigValue(type), type == Metal.ItemType.INGOT ? TFCTags.Fluids.USABLE_IN_INGOT_MOLD : TFCTags.Fluids.USABLE_IN_TOOL_HEAD_MOLD, properties);
        assert (type.hasMold());
    }

    public MoldItem(final Supplier<Integer> capacity, final TagKey<Fluid> fluidTag, Item.Properties properties) {
        super(properties.component(TFCComponents.HEAT, (Object)HeatComponent.of(1.2f)).component(TFCComponents.FLUID, (Object)FluidComponent.EMPTY));
        this.containerInfo = new FluidContainerInfo(){

            @Override
            public boolean canContainFluid(Fluid input) {
                return Helpers.isFluid(input, (TagKey<Fluid>)fluidTag) && FluidHeat.get(input) != null;
            }

            @Override
            public int fluidCapacity() {
                return (Integer)capacity.get();
            }
        };
    }

    public FluidContainerInfo containerInfo() {
        return this.containerInfo;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        IMold mold = IMold.get(stack);
        if (mold != null) {
            if (player.isShiftKeyDown()) {
                CastingRecipe recipe = CastingRecipe.get(mold);
                if (recipe != null) {
                    if (mold.isMolten()) {
                        player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.small_vessel.alloy_molten"), true);
                        return InteractionResultHolder.consume((Object)stack);
                    }
                    ItemStack result = recipe.assemble(mold);
                    mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
                    if (player.getRandom().nextFloat() < recipe.getBreakChance()) {
                        stack.shrink(1);
                        level.playSound(null, player.blockPosition(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.pass((Object)stack);
                }
            } else {
                if (mold.isMolten()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        TFCContainerProviders.MOLD_LIKE_ALLOY.openScreen(serverPlayer, hand);
                    }
                } else if (!mold.getFluidInTank(0).isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.small_vessel.alloy_solid"), true);
                }
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack carried, Slot slot, ClickAction action, Player player, SlotAccess carriedSlot) {
        CastingRecipe recipe;
        IMold mold;
        if (action == ClickAction.SECONDARY && !player.isCreative() && slot.allowModification(player) && (mold = IMold.get(stack)) != null && !mold.isMolten() && (recipe = CastingRecipe.get(mold)) != null) {
            boolean stackable;
            ItemStack result = recipe.assemble(mold);
            boolean noCarry = carried.isEmpty();
            boolean bl = stackable = ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)carried) && result.getCount() + carried.getCount() <= carried.getMaxStackSize();
            if (!noCarry && !stackable) {
                return false;
            }
            mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            if (noCarry) {
                carriedSlot.set(result);
            } else {
                carried.grow(result.getCount());
            }
            if (player.getRandom().nextFloat() < recipe.getBreakChance()) {
                stack.shrink(1);
                player.level().playSound(null, player.blockPosition(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.containerMenu.slotsChanged(slot.container);
            return true;
        }
        return false;
    }

    public int getMaxStackSize(ItemStack stack) {
        return FluidHelpers.getContainedFluidInTank(stack.copyWithCount(1)).isEmpty() ? super.getMaxStackSize(stack) : 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        FluidStack fluid = FluidHelpers.getContainedFluidInTank(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((Component)Tooltips.fluidUnitsAndCapacityOf(fluid, this.containerInfo.fluidCapacity()));
        }
    }
}

