/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.Deposit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class PanItem
extends Item {
    public static final int USE_TIME = 120;

    public PanItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 120;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        if (Helpers.isFluid(level.getFluidState(player.blockPosition()), TFCTags.Fluids.ANY_INFINITE_WATER)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        if (!level.isClientSide) {
            player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.pan.water"), true);
        }
        return super.use(level, player, hand);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int countLeft) {
        if (countLeft % 16 == 0 && !level.isClientSide) {
            level.playSound(null, (Entity)entity, (SoundEvent)TFCSounds.PANNING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                @Nullable Deposit depositStack = Deposit.get(((ItemComponent)stack.getOrDefault(TFCComponents.DEPOSIT, (Object)ItemComponent.EMPTY)).stack());
                if (depositStack != null) {
                    LootTable table = level.getServer().reloadableRegistries().getLootTable(depositStack.lootTable());
                    LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.TOOL, (Object)stack);
                    ObjectArrayList items = table.getRandomItems(builder.create(LootContextParamSets.FISHING));
                    items.forEach(item -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item));
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    return new ItemStack((ItemLike)TFCItems.EMPTY_PAN.get());
                }
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        @Nullable ItemStack deposit = ((ItemComponent)stack.getOrDefault(TFCComponents.DEPOSIT, (Object)ItemComponent.EMPTY)).stack();
        if (deposit != null) {
            tooltip.add((Component)Component.translatable((String)"tfc.tooltip.pan.contents").append(deposit.getHoverName()));
        }
    }
}

