/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.component.Bait;
import net.dries007.tfc.common.component.BaitType;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class TFCFishingRodItem
extends FishingRodItem {
    private final Tier tier;

    public static boolean isThisTheHeldRod(Player player, ItemStack stack) {
        boolean off;
        boolean main = player.getMainHandItem() == stack;
        boolean bl = off = player.getOffhandItem() == stack;
        if (player.getMainHandItem().getItem() instanceof FishingRodItem) {
            off = false;
        }
        return main || off;
    }

    public TFCFishingRodItem(Item.Properties properties, Tier tier) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack rod = player.getItemInHand(hand);
        if (player.fishing != null) {
            int dmg = player.fishing.retrieve(rod);
            Helpers.damageItem(rod, dmg, (LivingEntity)player, hand);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                ItemStack bait = Bait.getBait(rod);
                if (bait.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.fishing.no_bait"), true);
                } else {
                    level.addFreshEntity((Entity)new TFCFishingHook(player, level, this.getFishingStrength(), bait.copy()));
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)rod, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ItemStack bait = Bait.getBait(stack);
        if (!bait.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tfc.tooltip.fishing.bait").append(bait.getHoverName()));
        }
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack carried, Slot slot, ClickAction action, Player player, SlotAccess carriedSlot) {
        BaitType type = BaitType.getType(carried);
        if (type != BaitType.NONE && !player.isCreative() && action == ClickAction.SECONDARY && slot.allowModification(player) && (type == BaitType.SMALL && Helpers.isItem(stack, TFCTags.Items.HOLDS_SMALL_FISHING_BAIT) || type == BaitType.LARGE && Helpers.isItem(stack, TFCTags.Items.HOLDS_LARGE_FISHING_BAIT))) {
            Bait.setBait(stack, carried.split(1));
            return true;
        }
        return false;
    }

    public float getFishingStrength() {
        return this.tier.getSpeed() / 12.0f + 1.0f;
    }
}

