/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.common.entities.misc.TFCMinecartChest;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;

public class TFCMinecartItem
extends Item {
    private final Supplier<? extends EntityType<?>> entityType;
    private final Supplier<? extends Item> containedItem;

    public TFCMinecartItem(Item.Properties properties, Supplier<? extends EntityType<?>> entityType, Supplier<? extends Item> containedItem) {
        super(properties);
        this.entityType = entityType;
        this.containedItem = containedItem;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (!Helpers.isBlock(state, (TagKey<Block>)BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack held = context.getItemInHand();
        if (!level.isClientSide) {
            double z;
            double y;
            double x;
            RailShape railshape = state.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)state.getBlock()).getRailDirection(state, (BlockGetter)level, pos, null) : RailShape.NORTH_SOUTH;
            double offset = 0.0;
            if (railshape.isAscending()) {
                offset = 0.5;
            }
            if (this.createMinecartEntity(level, held, x = (double)pos.getX() + 0.5, y = (double)pos.getY() + 0.0625 + offset, z = (double)pos.getZ() + 0.5)) {
                level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean createMinecartEntity(Level level, ItemStack stack, double x, double y, double z) {
        Entity entity = this.entityType.get().create(level);
        if (entity != null) {
            entity.setPos(x, y, z);
            entity.xo = x;
            entity.yo = y;
            entity.zo = z;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                entity.setCustomName(stack.getHoverName());
            }
            this.beforeEntityAdded(level, stack, entity);
            level.addFreshEntity(entity);
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public void beforeEntityAdded(Level level, ItemStack stack, Entity entity) {
        if (entity instanceof TFCMinecartChest) {
            TFCMinecartChest chest = (TFCMinecartChest)entity;
            chest.setPickResult(stack);
            chest.setChestItem(new ItemStack((ItemLike)this.containedItem.get()));
        }
    }
}

