/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TorchItem
extends StandingAndWallBlockItem {
    public TorchItem(Block floorBlock, Block wallBlockIn, Item.Properties propertiesIn) {
        super(floorBlock, wallBlockIn, propertiesIn, Direction.DOWN);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        if (StartFireEvent.startFire(level, pos = context.getClickedPos(), level.getBlockState(pos), context.getClickedFace(), context.getPlayer(), context.getItemInHand(), StartFireEvent.FireStrength.WEAK, -1.0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        int ageRequirement;
        BlockPos pos;
        Level level = itemEntity.level();
        BlockState stateAt = level.getBlockState(pos = itemEntity.blockPosition());
        if (FluidHelpers.canFluidExtinguishFire(stateAt.getFluidState().getType())) {
            int amount;
            int n = amount = stack.getCount() > 5 ? 1 + level.random.nextInt(5) : stack.getCount();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < amount; ++i) {
                    Helpers.dropWithContext(serverLevel, ((Block)TFCBlocks.TORCH.get()).defaultBlockState(), pos, builder -> builder.withParameter(TFCLoot.BURNT_OUT, (Object)true), true);
                }
            }
            Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
            stack.shrink(amount);
            if (stack.isEmpty()) {
                itemEntity.discard();
                return true;
            }
            return false;
        }
        BlockPos downPos = itemEntity.blockPosition().below();
        boolean isNotInBlock = level.isEmptyBlock(pos);
        BlockState checkState = isNotInBlock ? level.getBlockState(downPos) : stateAt;
        int n = ageRequirement = isNotInBlock ? 20 : 160;
        if (Helpers.isBlock(checkState, TFCTags.Blocks.LIT_BY_DROPPED_TORCH)) {
            if (itemEntity.getAge() > ageRequirement && level.random.nextFloat() < 0.01f && !level.isClientSide()) {
                StartFireEvent.startFire(level, isNotInBlock ? downPos : pos, checkState, Direction.UP, null, ItemStack.EMPTY, StartFireEvent.FireStrength.STRONG, -1.0);
                itemEntity.kill();
                return true;
            }
            RandomSource rand = level.getRandom();
            if (rand.nextDouble() <= 0.1) {
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
            }
        }
        return false;
    }
}

