/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.heat.HeatComponent;
import net.dries007.tfc.common.component.mold.Vessel;
import net.dries007.tfc.common.component.mold.VesselComponent;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.FluidHeat;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class VesselItem
extends Item {
    public static final int SLOTS = 4;
    private final Vessel.ContainerInfo containerInfo = new Vessel.ContainerInfo(this){

        @Override
        public boolean canContainFluid(Fluid input) {
            return FluidHeat.get(input) != null;
        }

        @Override
        public int fluidCapacity() {
            return TFCConfig.SERVER.smallVesselCapacity.get();
        }

        @Override
        public boolean canContainItem(ItemStack stack) {
            return ItemSizeManager.get(stack).getSize(stack).isEqualOrSmallerThan(TFCConfig.SERVER.smallVesselMaximumItemSize.get());
        }

        @Override
        public int slotCapacity() {
            return 16;
        }
    };

    public VesselItem(Item.Properties properties) {
        super(properties.component(TFCComponents.VESSEL, (Object)VesselComponent.EMPTY).component(TFCComponents.HEAT, (Object)HeatComponent.of(1.2f)));
    }

    public Vessel.ContainerInfo containerInfo() {
        return this.containerInfo;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        Vessel vessel = Vessel.get(stack);
        if (vessel != null && vessel.isInventory() && TFCConfig.SERVER.enableSmallVesselInventoryInteraction.get().booleanValue() && !player.isCreative() && action == ClickAction.SECONDARY) {
            for (int i = 3; i >= 0; --i) {
                ItemStack extracted;
                ItemStack leftover;
                ItemStack simulate = vessel.extractItem(i, 64, true);
                if (simulate.isEmpty() || (leftover = slot.safeInsert(extracted = vessel.extractItem(i, 64, false))).isEmpty()) continue;
                vessel.insertItem(i, leftover, false);
                player.containerMenu.slotsChanged(slot.container);
                return true;
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack carried, Slot slot, ClickAction action, Player player, SlotAccess carriedSlot) {
        Vessel vessel = Vessel.get(stack);
        if (vessel != null && vessel.isInventory() && TFCConfig.SERVER.enableSmallVesselInventoryInteraction.get().booleanValue() && !player.isCreative() && action == ClickAction.SECONDARY && slot.allowModification(player)) {
            if (!carried.isEmpty()) {
                boolean slotsChanged = false;
                ItemStack oldCarried = carried.copy();
                for (int i = 0; i < 4; ++i) {
                    ItemStack leftover = vessel.insertItem(i, carried, false);
                    if (leftover.getCount() != oldCarried.getCount() || slotsChanged) {
                        slotsChanged = true;
                        carriedSlot.set(leftover);
                        carried = leftover;
                    }
                    if (carried.isEmpty()) break;
                }
                if (slotsChanged) {
                    player.containerMenu.slotsChanged(slot.container);
                    return true;
                }
            } else {
                for (int i = 3; i >= 0; --i) {
                    ItemStack current = vessel.getStackInSlot(i);
                    if (current.isEmpty()) continue;
                    carriedSlot.set(vessel.extractItem(i, 64, false));
                    player.containerMenu.slotsChanged(slot.container);
                    return true;
                }
            }
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() && !level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Vessel vessel = Vessel.get(stack);
            if (vessel != null) {
                if (vessel.isInventory()) {
                    if (vessel.getTemperature() > 0.0f) {
                        player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.small_vessel.inventory_too_hot"), true);
                    } else {
                        TFCContainerProviders.SMALL_VESSEL.openScreen(serverPlayer, hand);
                    }
                } else if (vessel.isMolten()) {
                    TFCContainerProviders.MOLD_LIKE_ALLOY.openScreen(serverPlayer, hand);
                } else if (vessel.getTemperature() > 0.0f && !vessel.hasFluidContent()) {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.small_vessel.inventory_too_hot"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.small_vessel.alloy_solid"), true);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        @Nullable Vessel vessel = Vessel.get(stack);
        if (vessel != null && vessel.isEmpty()) {
            if (vessel.isInventory()) {
                if (!TFCConfig.CLIENT.displayItemContentsAsImages.get().booleanValue()) {
                    tooltip.add((Component)Component.translatable((String)"tfc.tooltip.small_vessel.contents").withStyle(ChatFormatting.DARK_GREEN));
                    Helpers.addInventoryTooltipInfo(vessel.contents(), tooltip);
                }
            } else if (!vessel.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"tfc.tooltip.small_vessel.contents").withStyle(ChatFormatting.DARK_GREEN));
                tooltip.add((Component)Tooltips.fluidUnitsAndCapacityOf(vessel.getFluidInTank(0).getHoverName(), vessel.getFluidInTank(0).getAmount(), this.containerInfo.fluidCapacity()).append((Component)Tooltips.moltenOrSolid(vessel.isMolten())));
                if (!Helpers.isEmpty(vessel.contents())) {
                    tooltip.add((Component)Component.translatable((String)"tfc.tooltip.small_vessel.still_has_unmelted_items").withStyle(ChatFormatting.RED));
                }
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        Vessel vessel;
        if (TFCConfig.CLIENT.displayItemContentsAsImages.get().booleanValue() && (vessel = Vessel.get(stack)) != null && vessel.isInventory()) {
            return TooltipBlock.buildInventoryTooltip(vessel.contents(), 2, 2);
        }
        return Optional.empty();
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }
}

