/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WindmillBladeItem
extends Item {
    public WindmillBladeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AxleBlock) {
            AxleBlock axle = (AxleBlock)block;
            if (state.getValue((Property)AxleBlock.AXIS) != Direction.Axis.Y) {
                Direction.Axis axis = (Direction.Axis)state.getValue((Property)AxleBlock.AXIS);
                if (WindmillBlockEntity.isObstructedBySolidBlocks(level, pos, axis)) {
                    if (player != null) {
                        player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.windmill_not_enough_space"), true);
                    }
                    return InteractionResult.FAIL;
                }
                BlockState windmillState = (BlockState)((BlockState)axle.getWindmill().defaultBlockState().setValue(WindmillBlock.AXIS, (Comparable)axis)).setValue((Property)WindmillBlock.COUNT, (Comparable)Integer.valueOf(1));
                level.setBlockAndUpdate(pos, windmillState);
                Helpers.insertOne(level, pos, TFCBlockEntities.WINDMILL, context.getItemInHand().copyWithCount(1));
                if (player == null || !player.isCreative()) {
                    context.getItemInHand().shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }
}

