/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.player;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dries007.tfc.client.IngameOverlays;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class ChiselMode {
    public static final ResourceKey<Registry<ChiselMode>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("chisel_mode"));
    public static final DefaultedRegistry<ChiselMode> REGISTRY = (DefaultedRegistry)new RegistryBuilder(KEY).sync(true).defaultKey(Helpers.identifier("smooth")).create();
    public static final DeferredRegister<ChiselMode> MODES = DeferredRegister.create(KEY, (String)"tfc");
    public static final DeferredHolder<ChiselMode, ChiselMode> SMOOTH = ChiselMode.register("smooth", new ChiselMode(0){

        @Override
        public BlockState modifyStateForPlacement(BlockState state, BlockState chiseled, Player player, BlockHitResult hit) {
            return chiseled;
        }

        @Override
        public <T> T createIcon(IconCallback<T> callback) {
            return callback.accept(IngameOverlays.TEXTURE, 0, 58, 20, 20);
        }

        @Override
        public void createHotbarIcon(HotbarIconCallback callback) {
            callback.accept(IngameOverlays.TEXTURE, 0, 58);
        }
    });
    public static final DeferredHolder<ChiselMode, ChiselMode> SLAB = ChiselMode.register("slab", new ChiselMode(100){

        @Override
        @Nullable
        public BlockState modifyStateForPlacement(BlockState state, BlockState chiseled, Player player, BlockHitResult hit) {
            Direction hitFace = hit.getDirection();
            SlabType slabType = !(hitFace == Direction.DOWN || hitFace != Direction.UP && hit.getLocation().y - (double)hit.getBlockPos().getY() > 0.5) ? SlabType.BOTTOM : SlabType.TOP;
            chiseled = (BlockState)chiseled.setValue((Property)SlabBlock.TYPE, (Comparable)slabType);
            chiseled = FluidHelpers.fillWithFluid(chiseled, state.getFluidState().getType());
            return chiseled;
        }

        @Override
        public <T> T createIcon(IconCallback<T> callback) {
            return callback.accept(IngameOverlays.TEXTURE, 40, 58, 20, 20);
        }

        @Override
        public void createHotbarIcon(HotbarIconCallback callback) {
            callback.accept(IngameOverlays.TEXTURE, 40, 58);
        }
    });
    public static final DeferredHolder<ChiselMode, ChiselMode> STAIR = ChiselMode.register("stair", new ChiselMode(200){

        @Override
        @Nullable
        public BlockState modifyStateForPlacement(BlockState state, BlockState chiseled, Player player, BlockHitResult hit) {
            StairBlock stair;
            Block block = chiseled.getBlock();
            if (block instanceof StairBlock && (chiseled = (stair = (StairBlock)block).getStateForPlacement(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)stair), hit))) != null) {
                chiseled = FluidHelpers.fillWithFluid(chiseled, state.getFluidState().getType());
            }
            return chiseled;
        }

        @Override
        public <T> T createIcon(IconCallback<T> callback) {
            return callback.accept(IngameOverlays.TEXTURE, 20, 58, 20, 20);
        }

        @Override
        public void createHotbarIcon(HotbarIconCallback callback) {
            callback.accept(IngameOverlays.TEXTURE, 20, 58);
        }
    });
    private final int priority;
    @Nullable
    private ChiselMode next = null;

    public static void setupOrdering() {
        List<ChiselMode> order = REGISTRY.entrySet().stream().sorted(Comparator.comparingInt(e -> ((ChiselMode)e.getValue()).priority).thenComparing(Map.Entry::getKey)).map(Map.Entry::getValue).toList();
        for (int i = 0; i < order.size(); ++i) {
            order.get((int)(i == 0 ? order.size() - 1 : i - 1)).next = order.get(i);
        }
    }

    private static <T extends ChiselMode> DeferredHolder<ChiselMode, T> register(String name, T mode) {
        return MODES.register(name, () -> mode);
    }

    protected ChiselMode(int priority) {
        this.priority = priority;
    }

    public ChiselMode next() {
        return Objects.requireNonNull(this.next);
    }

    @Nullable
    public abstract BlockState modifyStateForPlacement(BlockState var1, BlockState var2, Player var3, BlockHitResult var4);

    public abstract <T> T createIcon(IconCallback<T> var1);

    public abstract void createHotbarIcon(HotbarIconCallback var1);

    public static interface HotbarIconCallback {
        public void accept(ResourceLocation var1, int var2, int var3);
    }

    public static interface IconCallback<T> {
        public T accept(ResourceLocation var1, int var2, int var3, int var4, int var5);
    }
}

