/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.player;

import net.dries007.tfc.common.TFCDamageTypes;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.component.food.INutritionData;
import net.dries007.tfc.common.component.food.NutritionData;
import net.dries007.tfc.common.player.ChiselMode;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PlayerInfoPacket;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.events.NutritionDataEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.LevelReader;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PlayerInfo
extends FoodData
implements IPlayerInfo {
    public static final int MAX_HUNGER = 20;
    public static final float EXHAUSTION_PER_HUNGER = 4.0f;
    public static final float MAX_THIRST = 100.0f;
    public static final float EXHAUSTION_MULTIPLIER = 0.4f;
    public static final float PASSIVE_HEALING_PER_TEN_TICKS = 0.0039999997f;
    public static final float PASSIVE_EXHAUSTION_PER_TICK = 0.0033333334f;
    public static final float MAX_TEMPERATURE_THIRST_DECAY = 0.4f;
    private final Player player;
    private final FoodData food;
    private float thirst = 100.0f;
    private long lastDrinkTick = Long.MIN_VALUE;
    private long intoxicationTick = Long.MIN_VALUE;
    private ChiselMode chiselMode = (ChiselMode)ChiselMode.SMOOTH.value();
    private INutritionData nutrition;
    private boolean modified = true;

    public PlayerInfo(Player player) {
        this.player = player;
        this.food = player.getFoodData();
        this.nutrition = PlayerInfo.getNutritionDataFromSupplier(0.5f, 0.0f, player);
    }

    @Override
    public void onDrink() {
        this.lastDrinkTick = this.calendar().getTicks();
        this.modified = true;
    }

    @Override
    public boolean canDrink() {
        return this.lastDrinkTick + 10L < this.calendar().getTicks();
    }

    @Override
    public ChiselMode chiselMode() {
        return this.chiselMode;
    }

    @Override
    public void cycleChiselMode() {
        this.chiselMode = this.chiselMode.next();
        this.modified = true;
    }

    @Override
    public float getIntoxication() {
        if (this.intoxicationTick == Long.MIN_VALUE) {
            return 0.0f;
        }
        return (float)Math.max(0L, this.intoxicationTick - this.calendar().getTicks()) / (float)TFCConfig.SERVER.maxIntoxicationTicks.get().intValue();
    }

    @Override
    public void addIntoxication(long ticks) {
        long currentTick = this.calendar().getTicks();
        if (this.intoxicationTick < currentTick) {
            this.intoxicationTick = currentTick;
        }
        this.intoxicationTick += ticks;
        if (this.intoxicationTick > currentTick + (long)TFCConfig.SERVER.maxIntoxicationTicks.get().intValue()) {
            this.intoxicationTick = currentTick + (long)TFCConfig.SERVER.maxIntoxicationTicks.get().intValue();
        }
        this.modified = true;
    }

    @Override
    public float getThirst() {
        return this.thirst;
    }

    @Override
    public void setThirst(float value) {
        this.thirst = Mth.clamp((float)value, (float)0.0f, (float)100.0f);
        this.modified = true;
    }

    @Override
    public float getThirstContributionFromTemperature() {
        if (TFCConfig.SERVER.enableThirstOverheating.get().booleanValue()) {
            float temp = Climate.getTemperature(this.player.level(), this.player.blockPosition());
            return Mth.clampedMap((float)temp, (float)22.0f, (float)34.0f, (float)0.0f, (float)0.4f);
        }
        return 0.0f;
    }

    @Override
    public INutritionData nutrition() {
        return this.nutrition;
    }

    @Override
    public void eat(IFood food) {
        net.dries007.tfc.common.component.food.FoodData data = food.getData();
        if (!food.isRotten()) {
            this.eat(data);
        } else {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                RandomSource random = serverPlayer.getRandom();
                if ((double)random.nextFloat() < 0.6) {
                    serverPlayer.addEffect(new MobEffectInstance(MobEffects.HUNGER, 1800, 1));
                    if ((double)random.nextFloat() < 0.15) {
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.POISON, 1800, 0));
                    }
                }
                TFCAdvancements.EAT_ROTTEN_FOOD.trigger(serverPlayer);
            }
        }
    }

    @Override
    public void eat(net.dries007.tfc.common.component.food.FoodData food) {
        Player player;
        this.addThirst(food.water());
        this.addIntoxication(food.intoxication());
        if (!this.player.level().isClientSide) {
            this.nutrition.addNutrients(food, this.getFoodLevel());
        }
        if (food.hunger() > 0) {
            this.food.eat(food.hunger(), food.saturation() / (2.0f * (float)food.hunger()));
        }
        if (!this.player.level().isClientSide) {
            this.nutrition.setHungerAndUpdate(this.getFoodLevel());
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if ((double)this.nutrition.getAverageNutrition() >= 0.999) {
                TFCAdvancements.FULL_NUTRITION.trigger(serverPlayer);
            }
        }
        this.modified = true;
    }

    @Override
    public void onClientUpdate(PlayerInfoPacket packet) {
        this.lastDrinkTick = packet.lastDrinkTick();
        this.chiselMode = packet.chiselMode();
        this.thirst = packet.thirst();
        this.intoxicationTick = packet.intoxication();
        this.nutrition.onClientUpdate(packet.nutrients());
    }

    @Override
    public void copyOnDeath(IPlayerInfo info) {
        this.nutrition = info.nutrition();
    }

    public void tick(Player player) {
        Difficulty difficulty = player.level().getDifficulty();
        if (difficulty == Difficulty.PEACEFUL && TFCConfig.SERVER.enablePeacefulDifficultyPassiveRegeneration.get().booleanValue()) {
            if (player.getHealth() < player.getMaxHealth() && player.tickCount % 20 == 0) {
                player.heal(1.0f);
            }
            if (player.tickCount % 10 == 0) {
                if (this.needsFood()) {
                    this.setFoodLevel(this.getFoodLevel() + 1);
                }
                if (this.thirst < 100.0f) {
                    this.addThirst(5.0f);
                }
            }
        } else {
            player.causeFoodExhaustion(0.0033333334f * TFCConfig.SERVER.passiveExhaustionModifier.get().floatValue());
            if (this.food.getExhaustionLevel() >= 4.0f) {
                this.addThirst(-(TFCConfig.SERVER.thirstModifier.get().floatValue() * (1.0f + this.getThirstContributionFromTemperature())));
                if (difficulty == Difficulty.PEACEFUL && this.getSaturationLevel() <= 0.0f) {
                    this.setFoodLevel(Math.max(this.getFoodLevel() - 1, 0));
                }
            }
            if (difficulty == Difficulty.PEACEFUL && this.food.getExhaustionLevel() > 4.0f && this.getSaturationLevel() <= 0.0f) {
                this.setFoodLevel(Math.max(this.getFoodLevel() - 1, 0));
            }
        }
        this.food.tick(player);
        this.nutrition.setHungerAndUpdate(this.getFoodLevel());
        if (player.tickCount % 10 == 0 && player.isHurt() && (float)this.getFoodLevel() >= 4.0f && this.getThirst() > 20.0f) {
            float foodBonus = Mth.inverseLerp((float)this.getFoodLevel(), (float)4.0f, (float)20.0f);
            float thirstBonus = Mth.inverseLerp((float)this.getThirst(), (float)20.0f, (float)100.0f);
            float multiplier = 1.0f + foodBonus + thirstBonus;
            player.heal(multiplier * 0.0039999997f * TFCConfig.SERVER.naturalRegenerationModifier.get().floatValue());
        }
        if (player.tickCount % 100 == 0 && difficulty != Difficulty.PEACEFUL && !player.getAbilities().invulnerable) {
            if (this.thirst < 10.0f) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 160, 1, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 160, 1, false, false));
                if (this.thirst <= 0.0f) {
                    TFCDamageTypes.dehydration((Entity)player, 1.0f);
                }
            } else if (this.thirst < 20.0f) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 160, 0, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 160, 0, false, false));
            }
        }
        if (this.modified && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerInfoPacket(this.lastDrinkTick, this.thirst, this.chiselMode, this.intoxicationTick, this.nutrition.getNutrients()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.modified = false;
        }
    }

    public void readAdditionalSaveData(CompoundTag root) {
        CompoundTag tag = root.getCompound("tfc:food");
        this.food.readAdditionalSaveData(root);
        this.lastDrinkTick = tag.getLong("lastDrinkTick");
        this.thirst = tag.getFloat("thirst");
        this.chiselMode = (ChiselMode)ChiselMode.REGISTRY.get(ResourceLocation.tryParse((String)tag.getString("chiselMode")));
        this.nutrition.setHunger(this.getFoodLevel());
        this.nutrition.readFromNbt(tag.get("nutrition"));
        this.intoxicationTick = tag.getLong("intoxication");
    }

    public void addAdditionalSaveData(CompoundTag root) {
        CompoundTag tag = new CompoundTag();
        root.put("tfc:food", (Tag)tag);
        this.food.addAdditionalSaveData(root);
        tag.putLong("lastDrinkTick", this.lastDrinkTick);
        tag.putFloat("thirst", this.thirst);
        tag.putString("chiselMode", ChiselMode.REGISTRY.getKey((Object)this.chiselMode).toString());
        tag.put("nutrition", this.nutrition.writeToNbt());
        tag.putLong("intoxication", this.intoxicationTick);
    }

    @Override
    public void forceUpdate() {
        this.modified = true;
    }

    public void eat(FoodProperties foodProperties) {
    }

    public void eat(int foodLevelModifier, float saturationLevelModifier) {
    }

    public int getFoodLevel() {
        return this.food.getFoodLevel();
    }

    public int getLastFoodLevel() {
        return this.food.getLastFoodLevel();
    }

    public boolean needsFood() {
        return this.food.needsFood();
    }

    public void addExhaustion(float exhaustion) {
        this.food.addExhaustion(0.4f * exhaustion);
    }

    public float getExhaustionLevel() {
        return this.food.getExhaustionLevel();
    }

    public float getSaturationLevel() {
        return this.food.getSaturationLevel();
    }

    public void setFoodLevel(int foodLevel) {
        if (!this.player.level().isClientSide) {
            this.modified = true;
            this.nutrition.setHungerAndUpdate(foodLevel);
        }
        this.food.setFoodLevel(foodLevel);
    }

    public void setSaturation(float saturationLevel) {
        this.food.setSaturation(saturationLevel);
    }

    public void setExhaustion(float exhaustionLevel) {
        this.food.setExhaustion(exhaustionLevel);
    }

    private ICalendar calendar() {
        return Calendars.get((LevelReader)this.player.level());
    }

    private static INutritionData getNutritionDataFromSupplier(float defaultNutritionValue, float defaultDairyNutritionValue, Player player) {
        NutritionDataEvent event = new NutritionDataEvent(NutritionData::new, player);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getSupplier().create(defaultNutritionValue, defaultDairyNutritionValue);
    }

    @FunctionalInterface
    public static interface NutritionDataSupplier<T extends INutritionData> {
        public T create(float var1, float var2);
    }
}

