/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.jetbrains.annotations.VisibleForTesting;

public class AdvancedShapedRecipe
extends ShapedRecipe {
    public static final MapCodec<AdvancedShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ShapedRecipePattern.MAP_CODEC.forGetter(c -> c.pattern), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result), (App)ItemStackProvider.CODEC.optionalFieldOf("remainder").forGetter(c -> c.remainder), (App)Codec.INT.optionalFieldOf("input_row", (Object)0).forGetter(c -> c.inputRow), (App)Codec.INT.optionalFieldOf("input_column", (Object)0).forGetter(c -> c.inputColumn)).apply((Applicative)i, AdvancedShapedRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdvancedShapedRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ShapedRecipePattern.STREAM_CODEC, c -> c.pattern, (StreamCodec)ByteBufCodecs.BOOL, ShapedRecipe::showNotification, ItemStackProvider.STREAM_CODEC, c -> c.result, (StreamCodec)ByteBufCodecs.optional(ItemStackProvider.STREAM_CODEC), c -> c.remainder, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.inputRow, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.inputColumn, AdvancedShapedRecipe::new);
    private final ItemStackProvider result;
    private final Optional<ItemStackProvider> remainder;
    private final int inputSlot;
    private final int inputRow;
    private final int inputColumn;

    public AdvancedShapedRecipe(ShapedRecipePattern pattern, boolean showNotification, ItemStackProvider result, Optional<ItemStackProvider> remainder, int inputRow, int inputColumn) {
        super("", CraftingBookCategory.MISC, pattern, ItemStack.EMPTY, showNotification);
        this.result = result;
        this.remainder = remainder;
        this.inputSlot = RecipeHelpers.dissolveRowColumn(inputRow, inputColumn, pattern.width());
        this.inputRow = inputRow;
        this.inputColumn = inputColumn;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        RecipeHelpers.setCraftingInput(input);
        int matchSlot = RecipeHelpers.translateMatch(this, this.inputSlot, input);
        ItemStack inputStack = matchSlot != -1 ? input.getItem(matchSlot).copy() : ItemStack.EMPTY;
        ItemStack output = this.result.getSingleStack(inputStack);
        RecipeHelpers.clearCraftingInput();
        return output;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.getEmptyStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return this.remainder.map(remainder -> {
            RecipeHelpers.setCraftingInput(input);
            int matchSlot = RecipeHelpers.translateMatch(this, this.inputSlot, input);
            ItemStack inputStack = matchSlot != -1 ? input.getItem(matchSlot).copy() : ItemStack.EMPTY;
            NonNullList<ItemStack> remain = RecipeHelpers.getRemainderItemsWithProvider(input, remainder, inputStack);
            RecipeHelpers.clearCraftingInput();
            return remain;
        }).orElseGet(() -> super.getRemainingItems((RecipeInput)input));
    }

    public boolean isSpecial() {
        return this.result.dependsOnInput();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPED_CRAFTING.get();
    }

    @VisibleForTesting
    public Optional<ItemStackProvider> getRemainder() {
        return this.remainder;
    }
}

