/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.common.collect.BiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.dries007.tfc.common.component.forge.ForgeRule;
import net.dries007.tfc.common.component.forge.Forging;
import net.dries007.tfc.common.component.forge.ForgingCapability;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipe
implements ISimpleRecipe<Inventory> {
    private static final BiMap<ResourceLocation, AnvilRecipe> CACHE = IndirectHashCollection.createForRecipeId(TFCRecipeTypes.ANVIL);
    public static final MapCodec<AnvilRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.input), (App)Codec.INT.optionalFieldOf("tier", (Object)-1).forGetter(c -> c.minTier), (App)ForgeRule.CODEC.listOf().fieldOf("rules").validate(rules -> ForgeRule.isConsistent(rules) ? DataResult.success((Object)rules) : DataResult.error(() -> "The rules " + String.valueOf(rules) + " cannot be satisfied by any combination of steps!")).forGetter(c -> c.rules), (App)Codec.BOOL.optionalFieldOf("apply_bonus", (Object)false).forGetter(c -> c.applyForgingBonus), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.output)).apply((Applicative)i, AnvilRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnvilRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.input, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.minTier, (StreamCodec)ForgeRule.STREAM_CODEC.apply(ByteBufCodecs.list((int)3)), c -> c.rules, (StreamCodec)ByteBufCodecs.BOOL, c -> c.applyForgingBonus, ItemStackProvider.STREAM_CODEC, c -> c.output, AnvilRecipe::new);
    private final Ingredient input;
    private final int minTier;
    private final List<ForgeRule> rules;
    private final boolean applyForgingBonus;
    private final ItemStackProvider output;

    public static boolean hasAny(Level level, ItemStack stack, int tier) {
        return RecipeHelpers.getRecipes(level, TFCRecipeTypes.ANVIL).stream().anyMatch(r -> ((AnvilRecipe)r.value()).input.test(stack) && tier >= ((AnvilRecipe)r.value()).minTier);
    }

    public static List<RecipeHolder<AnvilRecipe>> getAll(Level level, ItemStack stack, int tier) {
        return RecipeHelpers.getRecipes(level, TFCRecipeTypes.ANVIL).stream().filter(r -> ((AnvilRecipe)r.value()).input.test(stack) && tier >= ((AnvilRecipe)r.value()).minTier).toList();
    }

    @Nullable
    public static AnvilRecipe byId(ResourceLocation id) {
        return (AnvilRecipe)CACHE.get((Object)id);
    }

    @Nullable
    public static ResourceLocation getId(AnvilRecipe recipe) {
        return (ResourceLocation)CACHE.inverse().get((Object)recipe);
    }

    public AnvilRecipe(Ingredient input, int minTier, List<ForgeRule> rules, boolean applyForgingBonus, ItemStackProvider output) {
        this.input = input;
        this.minTier = minTier;
        this.rules = rules;
        this.applyForgingBonus = applyForgingBonus;
        this.output = output;
    }

    public boolean matches(Inventory inventory, @Nullable Level level) {
        return this.input.test(inventory.getItem()) && this.isCorrectTier(inventory.getTier());
    }

    public boolean checkComplete(Inventory inventory) {
        Forging forging = ForgingCapability.get(inventory.getItem());
        return forging.matches(this.rules) && this.isWorkMatched(forging.work(), this.computeTarget(inventory));
    }

    public List<ForgeRule> getRules() {
        return this.rules;
    }

    public boolean shouldApplyForgingBonus() {
        return this.applyForgingBonus;
    }

    public boolean isCorrectTier(int anvilTier) {
        return anvilTier >= this.minTier;
    }

    public int getMinTier() {
        return this.minTier;
    }

    public ItemStack assemble(Inventory input, HolderLookup.Provider registries) {
        return this.output.getStack(input.getItem());
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.output.getEmptyStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.ANVIL.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.ANVIL.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int computeTarget(Inventory inventory) {
        return 40 + new XoroshiroRandomSource(inventory.getSeed()).forkPositional().fromHashOf(BuiltInRegistries.ITEM.getKey((Object)this.output.stack().getItem())).nextInt(74);
    }

    private boolean isWorkMatched(int work, int target) {
        int leeway = TFCConfig.SERVER.anvilAcceptableWorkRange.get();
        return work >= target - leeway && work <= target + leeway;
    }

    public static interface Inventory
    extends RecipeInput {
        public ItemStack getItem();

        public int getTier();

        public long getSeed();
    }
}

