/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.InstantFluidBarrelRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.ingredients.TFCIngredients;
import net.dries007.tfc.common.recipes.input.BarrelInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class BarrelRecipe
implements INoopInputRecipe,
IRecipePredicate<BarrelInventory> {
    public static final MapCodec<BarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SizedIngredient.FLAT_CODEC.optionalFieldOf("input_item").forGetter(c -> c.inputItem), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("input_fluid").forGetter(c -> c.inputFluid), (App)ItemStackProvider.CODEC.optionalFieldOf("output_item", (Object)ItemStackProvider.empty()).forGetter(c -> c.outputItem), (App)FluidStack.CODEC.optionalFieldOf("output_fluid", (Object)FluidStack.EMPTY).forGetter(c -> c.outputFluid), (App)SoundEvent.CODEC.optionalFieldOf("sound", (Object)Holder.direct((Object)SoundEvents.BREWING_STAND_BREW)).forGetter(c -> c.sound)).apply((Applicative)i, BarrelRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BarrelRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)SizedIngredient.STREAM_CODEC), c -> c.inputItem, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.inputFluid, ItemStackProvider.STREAM_CODEC, c -> c.outputItem, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, c -> c.outputFluid, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.SOUND_EVENT), c -> c.sound, BarrelRecipe::new);
    protected final Optional<SizedIngredient> inputItem;
    protected final SizedFluidIngredient inputFluid;
    protected final ItemStackProvider outputItem;
    protected final FluidStack outputFluid;
    protected final Holder<SoundEvent> sound;

    @Nullable
    public static <B extends BarrelRecipe> RecipeHolder<B> get(Level level, Supplier<RecipeType<B>> type, BarrelInventory input) {
        return RecipeHelpers.getHolder(level, type, input);
    }

    protected BarrelRecipe(BarrelRecipe parent) {
        this(parent.inputItem, parent.inputFluid, parent.outputItem, parent.outputFluid, parent.sound);
    }

    protected BarrelRecipe(Optional<SizedIngredient> inputItem, SizedFluidIngredient inputFluid, ItemStackProvider outputItem, FluidStack outputFluid, Holder<SoundEvent> sound) {
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.sound = sound;
    }

    @Override
    public boolean matches(BarrelInventory input) {
        return (this.inputItem.isEmpty() || this.inputItem.get().test(input.getStackInSlot(2))) && this.inputFluid.test(input.getFluidInTank(0));
    }

    public void assembleOutputs(BarrelInventory inventory) {
        inventory.whileMutable(() -> {
            FluidStack outputFluid;
            int remainingItemCount;
            ItemStack outputItem;
            ItemStack stack = Helpers.removeStack((IItemHandler)inventory, 2);
            FluidStack fluid = inventory.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            int multiplier = this.inputItem.isEmpty() ? fluid.getAmount() / this.inputFluid.amount() : Math.min(fluid.getAmount() / this.inputFluid.amount(), stack.getCount() / this.inputItem.get().count());
            if (!this.outputFluid.isEmpty()) {
                int capacity = TFCConfig.SERVER.barrelCapacity.get();
                if (FluidStack.isSameFluidSameComponents((FluidStack)this.outputFluid, (FluidStack)fluid)) {
                    capacity -= fluid.getAmount();
                }
                int maxMultiplier = capacity / this.outputFluid.getAmount();
                multiplier = Math.min(multiplier, maxMultiplier);
            }
            if (!(outputItem = this.outputItem.getSingleStack(stack)).isEmpty()) {
                Helpers.consumeInStackSizeIncrements(outputItem, multiplier * outputItem.getCount(), inventory::insertItemWithOverflow);
            }
            if ((remainingItemCount = stack.getCount() - multiplier * this.inputItem.map(SizedIngredient::count).orElse(0)) > 0) {
                ItemStack remainingStack = stack.copy();
                remainingStack.setCount(remainingItemCount);
                inventory.insertItemWithOverflow(remainingStack);
            }
            if ((outputFluid = this.outputFluid.copy()).isEmpty()) {
                int retainAmount = fluid.getAmount() - multiplier * this.inputFluid.amount();
                if (retainAmount > 0) {
                    FluidStack retainedFluid = fluid.copy();
                    retainedFluid.setAmount(retainAmount);
                    inventory.fill(retainedFluid, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                int amount = outputFluid.getAmount() * multiplier;
                if (FluidStack.isSameFluidSameComponents((FluidStack)outputFluid, (FluidStack)fluid)) {
                    amount += fluid.getAmount();
                }
                outputFluid.setAmount(Math.min(TFCConfig.SERVER.barrelCapacity.get(), amount));
                inventory.fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }

    public ItemStack getResultItem() {
        return this.outputItem.getEmptyStack();
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider provider) {
        return this.outputItem.getEmptyStack();
    }

    public RecipeSerializer<?> getSerializer() {
        throw new UnsupportedOperationException();
    }

    public RecipeType<?> getType() {
        throw new UnsupportedOperationException();
    }

    public SizedIngredient getInputItem() {
        return this.inputItem.orElse(TFCIngredients.EMPTY_ITEM);
    }

    public ItemStackProvider getOutputItem() {
        return this.outputItem;
    }

    public SizedFluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public SoundEvent getCompleteSound() {
        return (SoundEvent)this.sound.value();
    }

    public static class Builder {
        private final Consumer<BarrelRecipe> onFinish;
        private Optional<SizedIngredient> inputItem = Optional.empty();
        @Nullable
        private SizedFluidIngredient inputFluid = null;
        private ItemStackProvider outputItem = ItemStackProvider.empty();
        private FluidStack outputFluid = FluidStack.EMPTY;
        private Holder<SoundEvent> sound = Holder.direct((Object)SoundEvents.BREWING_STAND_BREW);

        public Builder(Consumer<BarrelRecipe> onFinish) {
            this.onFinish = onFinish;
        }

        public Builder input(ItemLike item) {
            return this.input(SizedIngredient.of((ItemLike)item, (int)1));
        }

        public Builder input(TagKey<Item> item) {
            return this.input(SizedIngredient.of(item, (int)1));
        }

        public Builder input(Ingredient item) {
            return this.input(new SizedIngredient(item, 1));
        }

        public Builder input(SizedIngredient item) {
            this.inputItem = Optional.of(item);
            return this;
        }

        public Builder input(TagKey<Fluid> fluid, int amount) {
            return this.input(SizedFluidIngredient.of(fluid, (int)amount));
        }

        public Builder input(Fluid fluid, int amount) {
            return this.input(SizedFluidIngredient.of((Fluid)fluid, (int)amount));
        }

        public Builder input(SizedFluidIngredient fluid) {
            this.inputFluid = fluid;
            return this;
        }

        public Builder output(ItemLike item) {
            return this.output(ItemStackProvider.of(item));
        }

        public Builder output(ItemStackProvider item) {
            this.outputItem = item;
            return this;
        }

        public Builder output(Fluid fluid, int amount) {
            return this.output(new FluidStack(fluid, amount));
        }

        public Builder output(FluidStack fluid) {
            this.outputFluid = fluid;
            return this;
        }

        public Builder sound(SoundEvent sound) {
            this.sound = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)sound);
            return this;
        }

        public void instant() {
            this.onFinish.accept(new InstantBarrelRecipe(this.parent()));
        }

        public void instantOnAdd(Fluid fluid) {
            this.instantOnAdd(SizedFluidIngredient.of((Fluid)fluid, (int)1));
        }

        public void instantOnAdd(SizedFluidIngredient addedFluid) {
            this.onFinish.accept(new InstantFluidBarrelRecipe(Objects.requireNonNull(this.inputFluid, "Missing input fluid"), addedFluid, this.outputFluid, this.sound));
        }

        public void sealed(int duration) {
            this.onFinish.accept(new SealedBarrelRecipe(this.parent(), duration, Optional.empty(), Optional.empty()));
        }

        public void sealed(ItemStackProvider onSeal, ItemStackProvider onUnseal) {
            this.onFinish.accept(new SealedBarrelRecipe(this.parent(), -1, Optional.of(onSeal), Optional.of(onUnseal)));
        }

        private BarrelRecipe parent() {
            return new BarrelRecipe(this.inputItem, Objects.requireNonNull(this.inputFluid, "Missing input fluid"), this.outputItem, this.outputFluid, this.sound);
        }
    }
}

