/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.network.StreamCodecs;
import net.dries007.tfc.world.Codecs;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockRecipe
implements INoopInputRecipe,
IRecipePredicate<BlockState> {
    protected final BlockIngredient ingredient;
    protected final Optional<BlockState> output;

    public static <R extends BlockRecipe> RecipeSerializer<R> serializer(BiFunction<BlockIngredient, Optional<BlockState>, R> factory) {
        return new RecipeSerializerImpl<R>(BlockRecipe.codec(factory), BlockRecipe.streamCodec(factory));
    }

    public static <R extends BlockRecipe> MapCodec<R> codec(BiFunction<BlockIngredient, Optional<BlockState>, R> factory) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)BlockIngredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codecs.BLOCK_STATE.optionalFieldOf("result").forGetter(c -> c.output)).apply((Applicative)i, factory));
    }

    public static <R extends BlockRecipe> StreamCodec<RegistryFriendlyByteBuf, R> streamCodec(BiFunction<BlockIngredient, Optional<BlockState>, R> factory) {
        return StreamCodec.composite(BlockIngredient.STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.optional(StreamCodecs.BLOCK_STATE), c -> c.output, factory);
    }

    protected BlockRecipe(BlockIngredient ingredient, Optional<BlockState> output) {
        this.ingredient = ingredient;
        this.output = output;
    }

    @Override
    public boolean matches(BlockState state) {
        return this.ingredient.test(state);
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.map(BlockBehaviour.BlockStateBase::getBlock).or(() -> this.ingredient.blocks().stream().findFirst()).map(ItemStack::new).orElse(ItemStack.EMPTY);
    }

    public BlockState assembleBlock(BlockState input) {
        return this.output.orElse(input);
    }

    public BlockIngredient getBlockIngredient() {
        return this.ingredient;
    }
}

