/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class CastingCraftingRecipe
extends CustomRecipe {
    public static final CastingCraftingRecipe INSTANCE = new CastingCraftingRecipe();

    private CastingCraftingRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput input, Level level) {
        IMold mold = this.getMold(input);
        return mold != null && !mold.isMolten() && CastingRecipe.get(mold) != null;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        CastingRecipe recipe;
        IMold mold = this.getMold(input);
        if (mold != null && (recipe = CastingRecipe.get(mold)) != null) {
            return recipe.assemble(mold);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList items = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            Player player;
            CastingRecipe recipe;
            ItemStack item = input.getItem(i);
            IMold mold = IMold.get(item);
            if (item.isEmpty() || mold == null || (recipe = CastingRecipe.get(mold)) == null || (player = RecipeHelpers.getCraftingPlayer()) == null || !(player.getRandom().nextFloat() > recipe.getBreakChance())) continue;
            mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            items.set(i, (Object)item.copy());
        }
        return items;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.CASTING_CRAFTING.get();
    }

    @Nullable
    private IMold getMold(CraftingInput input) {
        IMold mold = null;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (mold == null) {
                mold = IMold.get(stack);
                if (mold != null) continue;
                return null;
            }
            return null;
        }
        return mold;
    }
}

