/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.player.ChiselMode;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.network.StreamCodecs;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.world.Codecs;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ChiselRecipe
implements INoopInputRecipe {
    public static final IndirectHashCollection<Block, ChiselRecipe> CACHE = IndirectHashCollection.createForRecipe(r -> r.ingredient.blocks(), TFCRecipeTypes.CHISEL);
    public static final MapCodec<ChiselRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BlockIngredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codecs.BLOCK_STATE.fieldOf("result").forGetter(c -> c.output), (App)ChiselMode.REGISTRY.byNameCodec().fieldOf("mode").forGetter(c -> c.mode), (App)ItemStackProvider.CODEC.optionalFieldOf("item_output", (Object)ItemStackProvider.empty()).forGetter(c -> c.itemOutput)).apply((Applicative)i, ChiselRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChiselRecipe> STREAM_CODEC = StreamCodec.composite(BlockIngredient.STREAM_CODEC, c -> c.ingredient, StreamCodecs.BLOCK_STATE, c -> c.output, (StreamCodec)ByteBufCodecs.registry(ChiselMode.KEY), c -> c.mode, ItemStackProvider.STREAM_CODEC, c -> c.itemOutput, ChiselRecipe::new);
    private final BlockIngredient ingredient;
    private final BlockState output;
    private final ChiselMode mode;
    private final ItemStackProvider itemOutput;

    public static Either<BlockState, InteractionResult> computeResult(Player player, BlockState state, BlockHitResult hit, boolean informWhy) {
        ItemStack held = player.getMainHandItem();
        if (Helpers.isItem(held, TFCTags.Items.TOOLS_CHISEL) && Helpers.isItem(player.getOffhandItem(), TFCTags.Items.TOOLS_HAMMER)) {
            ChiselMode mode = IPlayerInfo.get(player).chiselMode();
            ChiselRecipe recipe = ChiselRecipe.getRecipe(state, mode);
            if (recipe == null) {
                if (informWhy) {
                    ChiselRecipe.complain(player, "no_recipe");
                }
                return Either.right((Object)InteractionResult.PASS);
            }
            @Nullable BlockState chiseled = mode.modifyStateForPlacement(state, recipe.output, player, hit);
            if (chiseled == null) {
                if (informWhy) {
                    ChiselRecipe.complain(player, "cannot_place");
                }
                return Either.right((Object)InteractionResult.FAIL);
            }
            return Either.left((Object)chiseled);
        }
        return Either.right((Object)InteractionResult.PASS);
    }

    private static void complain(Player player, String message) {
        player.displayClientMessage((Component)Component.translatable((String)("tfc.chisel." + message)), true);
    }

    @Nullable
    public static ChiselRecipe getRecipe(BlockState state, ChiselMode mode) {
        for (ChiselRecipe recipe : CACHE.getAll(state.getBlock())) {
            if (!recipe.matches(state, mode)) continue;
            return recipe;
        }
        return null;
    }

    public ChiselRecipe(BlockIngredient ingredient, BlockState output, ChiselMode mode, ItemStackProvider itemOutput) {
        this.ingredient = ingredient;
        this.output = output;
        this.mode = mode;
        this.itemOutput = itemOutput;
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)this.output.getBlock());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.CHISEL.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.CHISEL.get();
    }

    public boolean matches(BlockState state, ChiselMode mode) {
        return this.mode == mode && this.ingredient.test(state);
    }

    public ChiselMode getMode() {
        return this.mode;
    }

    public BlockIngredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getItemOutput(ItemStack chisel) {
        return this.itemOutput.getSingleStack(chisel);
    }
}

