/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.ArrayList;
import java.util.Optional;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.misc.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.BlockRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.Support;
import net.dries007.tfc.util.events.CollapseEvent;
import net.dries007.tfc.util.tracker.Collapse;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class CollapseRecipe
extends BlockRecipe {
    public static final IndirectHashCollection<Block, CollapseRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), TFCRecipeTypes.COLLAPSE);
    private static final CollapseRecipe FALLBACK = new CollapseRecipe();

    public static boolean canCollapse(BlockState input) {
        return CollapseRecipe.getRecipe(input) != null;
    }

    @Nullable
    public static CollapseRecipe getRecipe(BlockState input) {
        @Nullable CollapseRecipe recipe = RecipeHelpers.getRecipe(CACHE, input, input.getBlock());
        return recipe == null && FALLBACK.matches(input) ? FALLBACK : recipe;
    }

    public static boolean tryTriggerCollapse(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        if (!level.isClientSide() && level.isAreaLoaded(pos, 32)) {
            boolean fakeCollapse;
            boolean realCollapse = (double)random.nextFloat() < TFCConfig.SERVER.collapseTriggerChance.get();
            boolean bl = fakeCollapse = !realCollapse && (double)random.nextFloat() < TFCConfig.SERVER.collapseFakeTriggerChance.get();
            if (realCollapse || fakeCollapse) {
                int radX = (random.nextInt(5) + 4) / 2;
                int radY = (random.nextInt(3) + 2) / 2;
                int radZ = (random.nextInt(5) + 4) / 2;
                ArrayList<BlockPos> fakeCollapseStarts = new ArrayList<BlockPos>();
                for (BlockPos checking : Support.findUnsupportedPositions((BlockGetter)level, pos.offset(-radX, -radY, -radZ), pos.offset(radX, radY, radZ))) {
                    if (checking.equals((Object)pos) || !CollapseRecipe.canStartCollapse((LevelAccessor)level, checking)) continue;
                    if (fakeCollapse) {
                        fakeCollapseStarts.add(checking.immutable());
                        continue;
                    }
                    if (CollapseRecipe.startCollapse(level, checking)) {
                        level.playSound(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_LONG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
                if (!fakeCollapseStarts.isEmpty()) {
                    level.playSound(null, pos, (SoundEvent)TFCSounds.ROCK_SLIDE_LONG_FAKE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    ArrayList<BlockPos> startsToDisplay = fakeCollapseStarts.size() < 4 ? fakeCollapseStarts : Helpers.uniqueRandomSample(fakeCollapseStarts, Math.min(12, 3 + random.nextInt(fakeCollapseStarts.size() - 3)), random);
                    NeoForge.EVENT_BUS.post((Event)new CollapseEvent(level, pos, startsToDisplay, 0.0, true));
                    for (BlockPos start : startsToDisplay) {
                        BlockState fakeStartState = level.getBlockState(start);
                        level.levelEvent(null, 2001, start, Block.getId((BlockState)fakeStartState));
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean canStartCollapse(LevelAccessor level, BlockPos pos) {
        BlockPos posBelow = pos.below();
        BlockState state = level.getBlockState(pos);
        BlockState stateBelow = level.getBlockState(posBelow);
        return Helpers.isBlock(state, TFCTags.Blocks.CAN_START_COLLAPSE) && (TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posBelow, stateBelow, Direction.DOWN, state) || !stateBelow.isCollisionShapeFullBlock((BlockGetter)level, posBelow) || Helpers.isBlock(stateBelow, TFCTags.Blocks.NOT_SOLID_SUPPORTING));
    }

    public static boolean startCollapse(Level level, BlockPos centerPos) {
        RandomSource random = level.getRandom();
        int radius = TFCConfig.SERVER.collapseMinRadius.get() + random.nextInt(TFCConfig.SERVER.collapseRadiusVariance.get().intValue());
        int radiusSquared = radius * radius;
        ArrayList<BlockPos> secondaryPositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        TerraFirmaCraft.LOGGER.info("Collapse started at pos {}, with the block column {} -> (start: {}) -> {}", new Object[]{centerPos, level.getBlockState(centerPos.above()), level.getBlockState(centerPos), level.getBlockState(centerPos.below())});
        block0: for (BlockPos pos : BlockPos.betweenClosed((BlockPos)centerPos.offset(-radius, -4, -radius), (BlockPos)centerPos.offset(radius, -4, radius))) {
            boolean foundEmpty = false;
            for (int y = 0; y <= 8; ++y) {
                BlockPos.MutableBlockPos posAt = cursor.setWithOffset((Vec3i)pos, 0, y, 0);
                BlockState stateAt = level.getBlockState((BlockPos)posAt);
                if (foundEmpty && CollapseRecipe.canCollapse(stateAt) && posAt.distSqr((Vec3i)centerPos) < (double)radiusSquared && (double)random.nextFloat() < TFCConfig.SERVER.collapsePropagateChance.get() && CollapseRecipe.collapseBlock(level, (BlockPos)posAt, stateAt, true)) {
                    secondaryPositions.add(posAt.above());
                    continue block0;
                }
                foundEmpty = !stateAt.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)posAt);
            }
        }
        if (!secondaryPositions.isEmpty()) {
            WorldTracker.get(level).addCollapseData(new Collapse(centerPos, secondaryPositions, radiusSquared));
        }
        return !secondaryPositions.isEmpty();
    }

    public static boolean collapseBlock(Level level, BlockPos pos, BlockState state) {
        return CollapseRecipe.collapseBlock(level, pos, state, false);
    }

    public static boolean collapseBlock(Level level, BlockPos pos, BlockState state, boolean destroyBlockBelow) {
        CollapseRecipe recipe = CollapseRecipe.getRecipe(state);
        if (recipe != null) {
            BlockPos posBelow = pos.below();
            if (destroyBlockBelow && !TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posBelow, Direction.DOWN, Blocks.BEDROCK.defaultBlockState())) {
                level.destroyBlock(posBelow, true);
            }
            BlockState collapseState = recipe.assembleBlock(state);
            level.setBlockAndUpdate(pos, collapseState);
            level.addFreshEntity((Entity)new TFCFallingBlockEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, collapseState, 2.0f, 20));
            return true;
        }
        return false;
    }

    public CollapseRecipe(BlockIngredient ingredient, BlockState output) {
        super(ingredient, Optional.of(output));
    }

    CollapseRecipe(BlockIngredient ingredient, Optional<BlockState> output) {
        super(ingredient, output);
    }

    CollapseRecipe() {
        super(BlockIngredient.of(TFCTags.Blocks.CAN_COLLAPSE), Optional.empty());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.COLLAPSE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.COLLAPSE.get();
    }
}

