/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.input.BarrelInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;

public class InstantFluidBarrelRecipe
extends BarrelRecipe {
    public static final MapCodec<InstantFluidBarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("primary_fluid").forGetter(c -> c.inputFluid), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("added_fluid").forGetter(c -> c.addedFluid), (App)FluidStack.CODEC.optionalFieldOf("output_fluid", (Object)FluidStack.EMPTY).forGetter(c -> c.outputFluid), (App)SoundEvent.CODEC.optionalFieldOf("sound", (Object)Holder.direct((Object)SoundEvents.BREWING_STAND_BREW)).forGetter(c -> c.sound)).apply((Applicative)i, InstantFluidBarrelRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InstantFluidBarrelRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.inputFluid, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.addedFluid, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, c -> c.outputFluid, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.SOUND_EVENT), c -> c.sound, InstantFluidBarrelRecipe::new);
    private final SizedFluidIngredient addedFluid;

    public InstantFluidBarrelRecipe(SizedFluidIngredient primaryFluid, SizedFluidIngredient addedFluid, FluidStack outputFluid, Holder<SoundEvent> sound) {
        super(Optional.empty(), primaryFluid, ItemStackProvider.empty(), outputFluid, sound);
        this.addedFluid = addedFluid;
    }

    public SizedFluidIngredient getAddedFluid() {
        return this.addedFluid;
    }

    @Override
    public boolean matches(BarrelInventory container) {
        return this.matches(container.getStackInSlot(2), container.getFluidInTank(0)) || this.matches(container.getStackInSlot(0), container.getFluidInTank(0));
    }

    public boolean matches(ItemStack inputStack, FluidStack fluidStack) {
        FluidStack extractableFluid = FluidHelpers.getContainedFluid(inputStack);
        return this.inputFluid.test(fluidStack) && this.addedFluid.test(extractableFluid);
    }

    @Override
    public void assembleOutputs(BarrelInventory inventory) {
        inventory.whileMutable(() -> {
            FluidStack primaryFluid = inventory.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            boolean inputIsItemSlot = this.matches(inventory.getStackInSlot(2), primaryFluid);
            ItemStack originalStack = Helpers.removeStack((IItemHandler)inventory, inputIsItemSlot ? 2 : 0);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)originalStack.copyWithCount(1).getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler == null) {
                return;
            }
            FluidStack addedFluid = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            int multiplier = Math.min(primaryFluid.getAmount() / this.inputFluid.amount(), addedFluid.getAmount() / this.addedFluid.amount());
            int targetAddedFluid = multiplier * this.addedFluid.amount();
            FluidStack actualAddedFluid = fluidHandler.drain(targetAddedFluid, IFluidHandler.FluidAction.SIMULATE);
            if (actualAddedFluid.isEmpty() || actualAddedFluid.getAmount() < targetAddedFluid) {
                fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            } else {
                fluidHandler.drain(targetAddedFluid, IFluidHandler.FluidAction.EXECUTE);
            }
            FluidStack outputFluid = this.outputFluid.copy();
            outputFluid.setAmount(Math.min(TFCConfig.SERVER.barrelCapacity.get(), outputFluid.getAmount() * multiplier));
            inventory.fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
            FluidHelpers.updateContainerItem(originalStack, fluidHandler, (newOriginalStack, newContainerStack) -> {
                inventory.setStackInSlot(inputIsItemSlot ? 2 : 1, newOriginalStack);
                if (!newContainerStack.isEmpty()) {
                    inventory.insertItemWithOverflow(newContainerStack);
                }
            });
        });
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.INSTANT_FLUID_BARREL.get();
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.BARREL_INSTANT_FLUID.get();
    }
}

