/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.Collection;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class ItemRecipe
implements INoopInputRecipe,
IRecipePredicate<ItemStack> {
    protected final Ingredient ingredient;
    protected final ItemStackProvider result;

    protected ItemRecipe(Ingredient ingredient, ItemStackProvider result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }

    public ItemStack assemble(ItemStack input) {
        return this.result.getSingleStack(input);
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.result.getEmptyStack();
    }

    public Collection<Item> getValidItems() {
        return RecipeHelpers.itemKeys(this.ingredient);
    }

    public final Ingredient getIngredient() {
        return this.ingredient;
    }

    public final ItemStackProvider getResult() {
        return this.result;
    }

    @Override
    public boolean isSpecial() {
        return this.result.dependsOnInput();
    }
}

