/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.BlockEntityTooltip;
import net.dries007.tfc.util.tooltip.BlockEntityTooltips;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class JamPotRecipe
extends PotRecipe {
    public static final MapCodec<JamPotRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PotRecipe.CODEC.forGetter(c -> c), (App)ItemStack.CODEC.fieldOf("unsealed_result").forGetter(c -> c.jarredStack), (App)ItemStack.CODEC.fieldOf("sealed_result").forGetter(c -> c.jarredStackWithLid), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(c -> c.texture)).apply((Applicative)i, JamPotRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, JamPotRecipe> STREAM_CODEC = StreamCodec.composite(PotRecipe.STREAM_CODEC, c -> c, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.jarredStack, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.jarredStackWithLid, (StreamCodec)ResourceLocation.STREAM_CODEC, c -> c.texture, JamPotRecipe::new);
    public static final PotOutput.OutputType OUTPUT_TYPE = (provider, nbt) -> {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("unsealed_result"));
        ItemStack stack2 = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("sealed_result"));
        ResourceLocation texture = Helpers.resourceLocation(nbt.getString("texture"));
        return new JamOutput(stack, stack2, texture);
    };
    private final ItemStack jarredStack;
    private final ItemStack jarredStackWithLid;
    private final ResourceLocation texture;

    public JamPotRecipe(PotRecipe base, ItemStack jarredStack, ItemStack jarredStackWithLid, ResourceLocation texture) {
        super(base);
        this.jarredStack = jarredStack;
        this.jarredStackWithLid = jarredStackWithLid;
        this.texture = texture;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.jarredStackWithLid;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public PotOutput getOutput(PotBlockEntity.PotInventory inventory) {
        inventory.clearFluid();
        return new JamOutput(this.jarredStack.copy(), this.jarredStackWithLid.copy(), this.texture);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_JAM.get();
    }

    public record JamOutput(ItemStack unsealedStack, ItemStack sealedStack, ResourceLocation texture) implements PotOutput
    {
        @Override
        public boolean isEmpty() {
            return this.unsealedStack.isEmpty() || this.sealedStack.isEmpty();
        }

        @Override
        public ItemInteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            if (Helpers.isItem(clickedWith, TFCItems.EMPTY_JAR) && !this.unsealedStack.isEmpty()) {
                clickedWith.shrink(1);
                this.sealedStack.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.unsealedStack.split(1));
                return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
            if (Helpers.isItem(clickedWith, TFCItems.EMPTY_JAR_WITH_LID) && !this.sealedStack.isEmpty()) {
                clickedWith.shrink(1);
                this.unsealedStack.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.sealedStack.split(1));
                return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        @Override
        public ResourceLocation getRenderTexture() {
            return this.texture;
        }

        @Override
        public float getFluidYLevel() {
            return Mth.clampedMap((float)this.unsealedStack.getCount(), (float)0.0f, (float)4.0f, (float)0.4375f, (float)0.625f);
        }

        @Override
        public void write(HolderLookup.Provider provider, CompoundTag nbt) {
            nbt.put("unsealed_result", this.unsealedStack.save(provider));
            nbt.put("sealed_result", this.sealedStack.save(provider));
            nbt.putString("texture", this.texture.toString());
        }

        @Override
        public PotOutput.OutputType getType() {
            return OUTPUT_TYPE;
        }

        @Override
        public BlockEntityTooltip getTooltip() {
            return (level, state, pos, entity, tooltip) -> {
                BlockEntityTooltips.itemWithCount(tooltip, this.sealedStack);
                FoodCapability.addTooltipInfo(this.sealedStack, tooltip);
            };
        }
    }
}

