/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.util.data.KnappingPattern;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KnappingRecipe
implements INoopInputRecipe,
IRecipePredicate<KnappingContainer> {
    public static final MapCodec<KnappingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)KnappingType.MANAGER.byIdReferenceCodec().fieldOf("knapping_type").forGetter(c -> c.knappingType), (App)KnappingPattern.CODEC.forGetter(c -> c.pattern), (App)Ingredient.CODEC.optionalFieldOf("ingredient").forGetter(c -> c.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(c -> c.result)).apply((Applicative)i, KnappingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KnappingRecipe> STREAM_CODEC = StreamCodec.composite(KnappingType.MANAGER.byIdStreamCodec(), c -> c.knappingType, KnappingPattern.STREAM_CODEC, c -> c.pattern, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), c -> c.ingredient, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.result, KnappingRecipe::new);
    private final DataManager.Reference<KnappingType> knappingType;
    private final KnappingPattern pattern;
    private final Optional<Ingredient> ingredient;
    private final ItemStack result;

    @Nullable
    public static KnappingRecipe get(Level level, KnappingContainer input) {
        return (KnappingRecipe)RecipeHelpers.unbox(RecipeHelpers.getHolder(level, TFCRecipeTypes.KNAPPING, input));
    }

    public KnappingRecipe(DataManager.Reference<KnappingType> knappingType, KnappingPattern pattern, Optional<Ingredient> ingredient, ItemStack result) {
        this.knappingType = knappingType;
        this.pattern = pattern;
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public boolean matches(KnappingContainer input) {
        return input.getKnappingType() == this.knappingType.get() && input.getPattern().matches(this.getPattern()) && this.matchesItem(input.getOriginalStack());
    }

    public boolean matchesItem(ItemStack stack) {
        return this.ingredient.isEmpty() || this.ingredient.get().test(stack);
    }

    public ItemStack assemble() {
        return this.result.copy();
    }

    public DataManager.Reference<KnappingType> knappingType() {
        return this.knappingType;
    }

    public KnappingPattern getPattern() {
        return this.pattern;
    }

    @Nullable
    public Ingredient getIngredient() {
        return this.ingredient.orElse(null);
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.KNAPPING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.KNAPPING.get();
    }
}

