/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.ItemRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class QuernRecipe
extends ItemRecipe {
    public static final IndirectHashCollection<Item, QuernRecipe> CACHE = IndirectHashCollection.createForRecipe(ItemRecipe::getValidItems, TFCRecipeTypes.QUERN);
    public static final MapCodec<QuernRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result)).apply((Applicative)i, QuernRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuernRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, ItemStackProvider.STREAM_CODEC, c -> c.result, QuernRecipe::new);

    @Nullable
    public static QuernRecipe getRecipe(ItemStack input) {
        return RecipeHelpers.getRecipe(CACHE, input, input.getItem());
    }

    public QuernRecipe(Ingredient ingredient, ItemStackProvider result) {
        super(ingredient, result);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.QUERN.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.QUERN.get();
    }
}

