/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.mixin.accessor.RecipeManagerAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class RecipeHelpers {
    private static final ThreadLocal<Iterable<ItemStack>> CRAFTING_INPUT = ThreadLocal.withInitial(() -> Collections::emptyIterator);

    @Nullable
    public static Player getCraftingPlayer() {
        return CommonHooks.getCraftingPlayer();
    }

    public static void clearCraftingInput() {
        CRAFTING_INPUT.set(Collections::emptyIterator);
    }

    public static void setCraftingInput(CraftingInput input) {
        CRAFTING_INPUT.set(Helpers.iterate((RecipeInput)input));
    }

    public static void setCraftingInput(IItemHandler inventory, int startSlotInclusive, int endSlotExclusive) {
        CRAFTING_INPUT.set(Helpers.iterate(inventory, startSlotInclusive, endSlotExclusive));
    }

    public static Iterable<ItemStack> getCraftingInput() {
        return CRAFTING_INPUT.get();
    }

    public static NonNullList<ItemStack> getRemainderItemsWithProvider(CraftingInput input, ItemStackProvider provider, ItemStack primaryInput) {
        NonNullList results = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < results.size(); ++i) {
            ItemStack outputStack;
            ItemStack stack = input.getItem(i);
            if (ItemStack.isSameItem((ItemStack)primaryInput, (ItemStack)stack)) {
                outputStack = provider.getStack(stack.copyWithCount(1));
                if (outputStack.isEmpty()) continue;
                results.set(i, (Object)outputStack);
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            outputStack = stack.getCraftingRemainingItem();
            results.set(i, (Object)outputStack);
        }
        return results;
    }

    public static ItemStack getResultUnsafe(CraftingRecipe recipe) {
        return recipe.getResultItem(null);
    }

    public static Collection<Item> itemKeys(Ingredient ingredient) {
        return RecipeHelpers.stream(ingredient).toList();
    }

    public static Stream<Item> stream(Ingredient ingredient) {
        return Arrays.stream(ingredient.getItems()).map(ItemStack::getItem);
    }

    public static Collection<Fluid> fluidKeys(FluidIngredient ingredient) {
        return RecipeHelpers.stream(ingredient).toList();
    }

    public static Stream<Fluid> stream(SizedFluidIngredient ingredient) {
        return RecipeHelpers.stream(ingredient.ingredient());
    }

    public static Stream<Fluid> stream(FluidIngredient ingredient) {
        return Arrays.stream(ingredient.getStacks()).map(FluidStack::getFluid);
    }

    @Nullable
    public static <R extends Recipe<?>> R unbox(@Nullable RecipeHolder<R> holder) {
        return (R)(holder == null ? null : holder.value());
    }

    @Nullable
    public static <R extends IRecipePredicate<C>, C, K> R getRecipe(IndirectHashCollection<K, R> cache, C input, K key) {
        return RecipeHelpers.getRecipe(cache.getAll(key), input);
    }

    @Nullable
    public static <R extends IRecipePredicate<C>, C> R getRecipe(Collection<R> recipes, C input) {
        return (R)RecipeHelpers.getRecipe(recipes, input, IRecipePredicate::matches);
    }

    @Nullable
    public static <R, C> R getRecipe(Collection<R> recipes, C input, BiPredicate<R, C> test) {
        for (R recipe : recipes) {
            if (!test.test(recipe, input)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static <R extends Recipe<?> & IRecipePredicate<C>, C> RecipeHolder<R> getHolder(Level level, Supplier<RecipeType<R>> recipeType, C input) {
        return RecipeHelpers.getHolder(RecipeHelpers.getRecipes(level, recipeType), input);
    }

    @Nullable
    public static <R extends Recipe<?> & IRecipePredicate<C>, C> RecipeHolder<R> getHolder(RecipeManager recipes, Supplier<RecipeType<R>> recipeType, C input) {
        return RecipeHelpers.getHolder(RecipeHelpers.getRecipes(recipes, recipeType), input);
    }

    @Nullable
    private static <R extends Recipe<?> & IRecipePredicate<C>, C> RecipeHolder<R> getHolder(Collection<RecipeHolder<R>> recipes, C input) {
        for (RecipeHolder<R> recipe : recipes) {
            if (!((IRecipePredicate)recipe.value()).matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static <R extends Recipe<?>> Collection<RecipeHolder<R>> getRecipes(Level level, Supplier<RecipeType<R>> type) {
        return RecipeHelpers.getRecipes(level.getRecipeManager(), type);
    }

    public static <R extends Recipe<?>> Collection<RecipeHolder<R>> getRecipes(RecipeManager recipeManager, Supplier<RecipeType<R>> type) {
        return ((RecipeManagerAccessor)recipeManager).invoke$byType(type.get());
    }

    public static int dissolveRowColumn(int row, int column, int width) {
        return column + row * width;
    }

    public static int translateMatch(ShapedRecipe recipe, int targetIndex, CraftingInput inventory) {
        return RecipeHelpers.translateMatch((NonNullList<Ingredient>)recipe.getIngredients(), inventory, recipe.getWidth(), recipe.getHeight(), targetIndex);
    }

    public static int translateMatch(NonNullList<Ingredient> recipeItems, CraftingInput input, int width, int height, int targetIndex) {
        for (int startCol = 0; startCol <= input.width() - width; ++startCol) {
            for (int startRow = 0; startRow <= input.height() - height; ++startRow) {
                if (RecipeHelpers.matches(recipeItems, input, startCol, startRow, true, width, height)) {
                    return width - 1 - targetIndex % width + startCol + (targetIndex / width + startRow) * input.width();
                }
                if (!RecipeHelpers.matches(recipeItems, input, startCol, startRow, false, width, height)) continue;
                return targetIndex % width + startCol + (targetIndex / width + startRow) * input.width();
            }
        }
        return -1;
    }

    private static boolean matches(NonNullList<Ingredient> recipeItems, CraftingInput input, int startCol, int startRow, boolean mirrored, int width, int height) {
        for (int invCol = 0; invCol < input.width(); ++invCol) {
            for (int invRow = 0; invRow < input.height(); ++invRow) {
                int col = invCol - startCol;
                int row = invRow - startRow;
                Ingredient ingredient = Ingredient.EMPTY;
                if (col >= 0 && row >= 0 && col < width && row < height) {
                    ingredient = mirrored ? (Ingredient)recipeItems.get(width - col - 1 + row * width) : (Ingredient)recipeItems.get(col + row * width);
                }
                if (ingredient.test(input.getItem(invCol + invRow * input.width()))) continue;
                return false;
            }
        }
        return true;
    }
}

