/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.input.BarrelInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class SealedBarrelRecipe
extends BarrelRecipe {
    public static final MapCodec<SealedBarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BarrelRecipe.CODEC.forGetter(c -> c), (App)Codec.INT.fieldOf("duration").forGetter(c -> c.duration), (App)ItemStackProvider.CODEC.optionalFieldOf("on_seal").forGetter(c -> c.onSeal), (App)ItemStackProvider.CODEC.optionalFieldOf("on_unseal").forGetter(c -> c.onUnseal)).apply((Applicative)i, SealedBarrelRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SealedBarrelRecipe> STREAM_CODEC = StreamCodec.composite(BarrelRecipe.STREAM_CODEC, c -> c, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.duration, (StreamCodec)ByteBufCodecs.optional(ItemStackProvider.STREAM_CODEC), c -> c.onSeal, (StreamCodec)ByteBufCodecs.optional(ItemStackProvider.STREAM_CODEC), c -> c.onUnseal, SealedBarrelRecipe::new);
    private final int duration;
    private final Optional<ItemStackProvider> onSeal;
    private final Optional<ItemStackProvider> onUnseal;

    public SealedBarrelRecipe(BarrelRecipe parent, int duration, Optional<ItemStackProvider> onSeal, Optional<ItemStackProvider> onUnseal) {
        super(parent);
        this.duration = duration;
        this.onSeal = onSeal;
        this.onUnseal = onUnseal;
    }

    @Override
    public boolean matches(BarrelInventory container) {
        return super.matches(container) && this.moreFluidThanItems(container);
    }

    private boolean moreFluidThanItems(BarrelInventory input) {
        return !this.isInfinite() || this.inputItem.isEmpty() || input.getFluidInTank(0).getAmount() / this.inputFluid.amount() >= input.getStackInSlot(2).getCount() / ((SizedIngredient)this.inputItem.get()).count();
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isInfinite() {
        return this.duration <= 0;
    }

    @Nullable
    @Contract(pure=true)
    public ItemStackProvider onSeal() {
        return this.onSeal.orElse(null);
    }

    @Nullable
    @Contract(pure=true)
    public ItemStackProvider onUnseal() {
        return this.onUnseal.orElse(null);
    }

    public void onSealed(BarrelInventory inventory) {
        this.onSeal.ifPresent(onSeal -> inventory.whileMutable(() -> {
            ItemStack stack = Helpers.removeStack((IItemHandler)inventory, 2);
            inventory.insertItem(2, onSeal.getStack(stack), false);
        }));
    }

    public void onUnsealed(BarrelInventory inventory) {
        this.onUnseal.ifPresent(onUnseal -> inventory.whileMutable(() -> {
            ItemStack stack = Helpers.removeStack((IItemHandler)inventory, 2);
            inventory.insertItem(2, onUnseal.getStack(stack), false);
        }));
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.BARREL_SEALED.get();
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.SEALED_BARREL.get();
    }
}

