/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.common.base.Splitter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.container.SewingTableContainer;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SewingRecipe
implements ISimpleRecipe<SewingTableContainer.Input> {
    private static final int MAX_STITCHES = 45;
    public static final MapCodec<SewingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SewingRecipe.flatCodec(9, 5).comapFlatMap(SewingRecipe::stitchesToBitset, bitset -> {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < 45; ++j) {
            builder.append(SewingRecipe.bitFind(bitset, j) ? (char)'#' : (char)' ');
        }
        return builder.toString();
    }).fieldOf("stitches").forGetter(c -> c.stitches), (App)SewingRecipe.flatCodec(8, 4).fieldOf("squares").forGetter(c -> c.squares), (App)ItemStack.CODEC.fieldOf("result").forGetter(c -> c.result)).apply((Applicative)i, SewingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SewingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.stitches, (StreamCodec)ByteBufCodecs.STRING_UTF8, c -> c.squares, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.result, SewingRecipe::new);
    private final long stitches;
    private final String squares;
    private final ItemStack result;

    private static Codec<String> flatCodec(int width, int height) {
        return Codec.string((int)width, (int)width).listOf(height, height).xmap(list -> String.join((CharSequence)"", list), text -> Splitter.fixedLength((int)width).splitToList((CharSequence)text));
    }

    public static SewingRecipe from(String stitches, String squares, ItemStack result) {
        return new SewingRecipe((Long)SewingRecipe.stitchesToBitset(stitches).getOrThrow(), squares, result);
    }

    private static DataResult<Long> stitchesToBitset(String text) {
        if (text.length() != 45) {
            return DataResult.error(() -> "Must be exactly 45 stitches");
        }
        long bitset = 0L;
        for (int j = 0; j < 45; ++j) {
            bitset |= text.charAt(j) != ' ' ? 1L << j : 0L;
        }
        return DataResult.success((Object)bitset);
    }

    private static boolean bitFind(long bitset, int index) {
        return (bitset >> index & 1L) == 1L;
    }

    public SewingRecipe(long stitches, String squares, ItemStack result) {
        this.stitches = stitches;
        this.squares = squares;
        this.result = result;
    }

    public boolean getStitch(int index) {
        return SewingRecipe.bitFind(this.stitches, index);
    }

    public int getSquare(int index) {
        return this.squares.charAt(index) == '#' ? 1 : 0;
    }

    public boolean matches(SewingTableContainer.Input inventory, Level level) {
        return inventory.squaresMatch(this) && inventory.stitchesMatch(this);
    }

    public ItemStack assemble(SewingTableContainer.Input input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.SEWING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.SEWING.get();
    }
}

