/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.dries007.tfc.network.StreamCodecs;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record BlockIngredient(Either<ImmutableSet<Block>, TagKey<Block>> either) implements Predicate<Block>
{
    public static final Codec<BlockIngredient> CODEC = Codec.either((Codec)Codecs.BLOCK.listOf().xmap(ImmutableSet::copyOf, List::copyOf), (Codec)TagKey.hashedCodec((ResourceKey)Registries.BLOCK)).xmap(BlockIngredient::new, BlockIngredient::either);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockIngredient> STREAM_CODEC = ByteBufCodecs.either((StreamCodec)StreamCodecs.BLOCK.apply(ByteBufCodecs.list()).map(ImmutableSet::copyOf, List::copyOf), (StreamCodec)ResourceLocation.STREAM_CODEC.map(k -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)k), TagKey::location)).map(BlockIngredient::new, BlockIngredient::either);

    public static BlockIngredient of(TagKey<Block> tag) {
        return new BlockIngredient((Either<ImmutableSet<Block>, TagKey<Block>>)Either.right(tag));
    }

    public static BlockIngredient of(Block ... block) {
        assert (Arrays.stream(block).allMatch(b -> b != Blocks.AIR));
        return new BlockIngredient((Either<ImmutableSet<Block>, TagKey<Block>>)Either.left((Object)ImmutableSet.copyOf((Object[])block)));
    }

    public static BlockIngredient of(Stream<Block> blocks) {
        return new BlockIngredient((Either<ImmutableSet<Block>, TagKey<Block>>)Either.left((Object)ImmutableSet.copyOf(blocks.toList())));
    }

    @Override
    public boolean test(BlockState state) {
        return this.test(state.getBlock());
    }

    @Override
    public boolean test(Block block) {
        return (Boolean)this.either.map(s -> s.contains((Object)block), t -> Helpers.isBlock(block, (TagKey<Block>)t));
    }

    public Stream<Block> all() {
        return (Stream)this.either.map(Collection::stream, Helpers::allBlocks);
    }

    public List<Block> blocks() {
        return this.all().toList();
    }
}

