/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.recipes.ingredients.AndIngredient;
import net.dries007.tfc.common.recipes.ingredients.FluidContentIngredient;
import net.dries007.tfc.common.recipes.ingredients.HasTraitIngredient;
import net.dries007.tfc.common.recipes.ingredients.HeatIngredient;
import net.dries007.tfc.common.recipes.ingredients.LacksTraitIngredient;
import net.dries007.tfc.common.recipes.ingredients.NotRottenIngredient;
import net.dries007.tfc.common.recipes.ingredients.RottenIngredient;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class TFCIngredients {
    public static final SizedIngredient EMPTY_ITEM = new SizedIngredient(Ingredient.EMPTY, 1);
    public static final DeferredRegister<IngredientType<?>> TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"tfc");
    public static final Id<RottenIngredient> ROTTEN = TFCIngredients.register("rotten", RottenIngredient.CODEC, RottenIngredient.STREAM_CODEC);
    public static final Id<NotRottenIngredient> NOT_ROTTEN = TFCIngredients.register("not_rotten", NotRottenIngredient.CODEC, NotRottenIngredient.STREAM_CODEC);
    public static final Id<HasTraitIngredient> HAS_TRAIT = TFCIngredients.register("has_trait", HasTraitIngredient.CODEC, HasTraitIngredient.STREAM_CODEC);
    public static final Id<LacksTraitIngredient> LACKS_TRAIT = TFCIngredients.register("lacks_trait", LacksTraitIngredient.CODEC, LacksTraitIngredient.STREAM_CODEC);
    public static final Id<HeatIngredient> HEAT = TFCIngredients.register("heat", HeatIngredient.CODEC, HeatIngredient.STREAM_CODEC);
    public static final Id<FluidContentIngredient> FLUID_CONTENT = TFCIngredients.register("fluid_content", FluidContentIngredient.CODEC, FluidContentIngredient.STREAM_CODEC);
    public static final Id<AndIngredient> AND = TFCIngredients.register("and", AndIngredient.CODEC, AndIngredient.STREAM_CODEC);

    private static <T extends ICustomIngredient> Id<T> register(String name, MapCodec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        return new Id(TYPES.register(name, () -> new IngredientType(codec, streamCodec)));
    }

    public record Id<T extends ICustomIngredient>(DeferredHolder<IngredientType<?>, IngredientType<T>> holder) implements RegistryHolder<IngredientType<?>, IngredientType<T>>
    {
    }
}

