/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.dries007.tfc.common.Lore;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifierType;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ChanceModifier(float chance) implements ItemStackModifier
{
    public static final MapCodec<ChanceModifier> CHANCE = Codec.FLOAT.fieldOf("chance").xmap(ChanceModifier::new, ChanceModifier::chance);
    public static final StreamCodec<ByteBuf, ChanceModifier> STREAM_CODEC = ByteBufCodecs.FLOAT.map(ChanceModifier::new, ChanceModifier::chance);

    @Override
    public ItemStack apply(ItemStack stack, ItemStack input, ItemStackModifier.Context context) {
        if (context != ItemStackModifier.Context.DEFAULT) {
            Lore.append(stack, Component.translatable((String)"tfc.tooltip.chance", (Object[])new Object[]{Float.valueOf(this.chance * 100.0f)}));
            return stack;
        }
        int count = 0;
        for (int i = 0; i < stack.getCount(); ++i) {
            if (!(Math.random() < (double)this.chance)) continue;
            ++count;
        }
        if (count > 0) {
            return stack.copyWithCount(count);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStackModifierType<?> type() {
        return (ItemStackModifierType)ItemStackModifiers.CHANCE.get();
    }
}

