/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifierType;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum DamageCraftingRemainderModifier implements ItemStackModifier
{
    INSTANCE;


    @Override
    public ItemStack apply(ItemStack stack, ItemStack input, ItemStackModifier.Context context) {
        if (input.isDamageableItem()) {
            @Nullable Player player = RecipeHelpers.getCraftingPlayer();
            if (player != null) {
                Helpers.damageItem(input, player.level());
            } else {
                Helpers.damageItem(input);
            }
        }
        if (input.has(DataComponents.MAX_DAMAGE) && input.has(DataComponents.DAMAGE)) {
            return input.copy();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStackModifierType<?> type() {
        return (ItemStackModifierType)ItemStackModifiers.DAMAGE_CRAFTING_REMAINDER.get();
    }
}

