/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.recipes.outputs.CopyInputModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record ItemStackProvider(ItemStack stack, List<ItemStackModifier> modifiers) {
    public static final Codec<ItemStackProvider> CODEC = Codec.either((Codec)RecordCodecBuilder.create(i -> i.group((App)ItemStack.CODEC.optionalFieldOf("stack", (Object)ItemStack.EMPTY).forGetter(c -> c.stack), (App)ItemStackModifier.CODEC.listOf().fieldOf("modifiers").forGetter(c -> c.modifiers)).apply((Applicative)i, ItemStackProvider::new)), (Codec)ItemStack.CODEC).xmap(e -> (ItemStackProvider)e.map(Function.identity(), ItemStackProvider::of), provider -> provider.modifiers.isEmpty() ? Either.right((Object)provider.stack) : Either.left((Object)provider));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackProvider> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, c -> c.stack, (StreamCodec)ItemStackModifier.STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.modifiers, ItemStackProvider::of);
    private static final ItemStackProvider EMPTY = ItemStackProvider.of(ItemStack.EMPTY);
    private static final ItemStackProvider COPY_INPUT = ItemStackProvider.of(ItemStack.EMPTY, CopyInputModifier.INSTANCE);

    public static ItemStackProvider empty() {
        return EMPTY;
    }

    public static ItemStackProvider copyInput() {
        return COPY_INPUT;
    }

    public static ItemStackProvider of(ItemLike item) {
        return ItemStackProvider.of(new ItemStack(item));
    }

    public static ItemStackProvider of(ItemLike item, int count) {
        return ItemStackProvider.of(new ItemStack(item, count));
    }

    public static ItemStackProvider of(ItemStack stack) {
        return ItemStackProvider.of(stack, List.of());
    }

    public static ItemStackProvider of(ItemStack stack, ItemStackModifier ... modifiers) {
        return ItemStackProvider.of(stack, List.of(modifiers));
    }

    public static ItemStackProvider of(ItemStackModifier ... modifiers) {
        return ItemStackProvider.of(ItemStack.EMPTY, List.of(modifiers));
    }

    public static ItemStackProvider of(ItemStack stack, List<ItemStackModifier> modifiers) {
        return new ItemStackProvider(FoodCapability.setTransientNonDecaying(stack), modifiers);
    }

    public ItemStack getSingleStack(ItemStack input) {
        return this.getStack(input.copyWithCount(1));
    }

    public ItemStack getSingleStackDisplayOnly(ItemStack input) {
        return this.getStack(input.copyWithCount(1), ItemStackModifier.Context.NO_RANDOM_CHANCE);
    }

    public ItemStack getEmptyStack() {
        return this.getStack(ItemStack.EMPTY, ItemStackModifier.Context.NO_RANDOM_CHANCE);
    }

    public ItemStack getStack(ItemStack input) {
        return this.getStack(input, ItemStackModifier.Context.DEFAULT);
    }

    public ItemStack getStack(ItemStack input, ItemStackModifier.Context context) {
        ItemStack output = this.stack.copy();
        for (ItemStackModifier modifier : this.modifiers) {
            output = modifier.apply(output, input, context);
        }
        return output;
    }

    public boolean dependsOnInput() {
        for (ItemStackModifier modifier : this.modifiers) {
            if (!modifier.dependsOnInput()) continue;
            return true;
        }
        return false;
    }
}

