/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifierType;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record MealModifier(FoodData baseFood, List<MealPortion> portions) implements ItemStackModifier
{
    public static final MapCodec<MealModifier> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)FoodData.CODEC.fieldOf("food").forGetter(c -> c.baseFood), (App)RecordCodecBuilder.create(j -> j.group((App)Ingredient.CODEC.optionalFieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codec.FLOAT.optionalFieldOf("nutrient_modifier", (Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.nutrientModifier)), (App)Codec.FLOAT.optionalFieldOf("water_modifier", (Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.waterModifier)), (App)Codec.FLOAT.optionalFieldOf("saturation_modifier", (Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.saturationModifier))).apply((Applicative)j, MealPortion::new)).listOf().fieldOf("portions").forGetter(c -> c.portions)).apply((Applicative)i, MealModifier::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MealModifier> STREAM_CODEC = StreamCodec.composite(FoodData.STREAM_CODEC, c -> c.baseFood, (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), c -> c.ingredient, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.nutrientModifier), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.waterModifier), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.saturationModifier), MealPortion::new).apply(ByteBufCodecs.list()), c -> c.portions, MealModifier::new);

    @Override
    public ItemStack apply(ItemStack stack, ItemStack input, ItemStackModifier.Context context) {
        @Nullable IFood inputFood = FoodCapability.get(stack);
        if (inputFood == null) {
            return stack;
        }
        ArrayList<ItemStack> itemIngredients = new ArrayList<ItemStack>();
        for (ItemStack item2 : RecipeHelpers.getCraftingInput()) {
            if (!FoodCapability.has(item2)) continue;
            boolean alreadyAdded = false;
            for (ItemStack existing : itemIngredients) {
                if (existing.getItem() != item2.getItem()) continue;
                existing.grow(1);
                alreadyAdded = true;
                break;
            }
            if (alreadyAdded) continue;
            ItemStack tooltipItem = item2.copyWithCount(1);
            FoodCapability.setNonDecaying(tooltipItem);
            HeatCapability.setTemperature(tooltipItem, 0.0f);
            itemIngredients.add(tooltipItem);
        }
        if (itemIngredients.isEmpty()) {
            return stack;
        }
        itemIngredients.sort(Comparator.comparing(ItemStack::getCount).thenComparing(item -> BuiltInRegistries.ITEM.getKey((Object)item.getItem())));
        float[] nutrition = this.baseFood.nutrients();
        float saturation = this.baseFood.saturation();
        float water = this.baseFood.water();
        HashMap<ItemStack, MealPortion> map = new HashMap<ItemStack, MealPortion>();
        for (ItemStack itemStack : itemIngredients) {
            MealPortion selected = null;
            for (MealPortion portion : this.portions) {
                if (!portion.test(itemStack)) continue;
                selected = portion;
                break;
            }
            if (selected == null) continue;
            map.put(itemStack, selected);
        }
        for (Map.Entry entry : map.entrySet()) {
            ItemStack item3 = (ItemStack)entry.getKey();
            MealPortion portion = (MealPortion)entry.getValue();
            @Nullable IFood food = FoodCapability.get(item3);
            if (food == null) continue;
            FoodData data = food.getData();
            for (Nutrient nutrient : Nutrient.VALUES) {
                int n = nutrient.ordinal();
                nutrition[n] = nutrition[n] + data.nutrient(nutrient) * portion.nutrientModifier * (float)item3.getCount();
            }
            water += data.water() * portion.waterModifier * (float)item3.getCount();
            saturation += data.saturation() * portion.saturationModifier * (float)item3.getCount();
        }
        stack.set(TFCComponents.INGREDIENTS, (Object)ItemListComponent.of(itemIngredients));
        FoodCapability.setFoodForDynamicItemOnCreate(stack, new FoodData(this.baseFood.hunger(), water, saturation, 0, nutrition, this.baseFood.decayModifier()));
        return stack;
    }

    @Override
    public ItemStackModifierType<?> type() {
        return (ItemStackModifierType)ItemStackModifiers.MEAL.get();
    }

    public record MealPortion(Optional<Ingredient> ingredient, float nutrientModifier, float waterModifier, float saturationModifier) {
        boolean test(ItemStack stack) {
            return this.ingredient.isEmpty() || this.ingredient.get().test(stack);
        }
    }
}

