/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jade;

import java.util.List;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.tooltip.BlockEntityTooltip;
import net.dries007.tfc.util.tooltip.BlockEntityTooltips;
import net.dries007.tfc.util.tooltip.EntityTooltip;
import net.dries007.tfc.util.tooltip.EntityTooltips;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.JadeIds;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeIntegration
implements IWailaPlugin {
    public static void registerToolHandlers() {
        HarvestToolProvider.registerHandler((ToolHandler)SimpleToolHandler.create((ResourceLocation)JadeIds.JADE((String)"pickaxe"), List.of(JadeIntegration.metalTool(Metal.COPPER, Metal.ItemType.PICKAXE), JadeIntegration.metalTool(Metal.BRONZE, Metal.ItemType.PICKAXE), JadeIntegration.metalTool(Metal.STEEL, Metal.ItemType.PICKAXE), JadeIntegration.metalTool(Metal.BLACK_STEEL, Metal.ItemType.PICKAXE))));
        JadeIntegration.register("axe", RockCategory.ItemType.AXE, Metal.ItemType.AXE);
        JadeIntegration.register("shovel", RockCategory.ItemType.SHOVEL, Metal.ItemType.SHOVEL);
        JadeIntegration.register("hoe", RockCategory.ItemType.HOE, Metal.ItemType.HOE);
        HarvestToolProvider.registerHandler((ToolHandler)SimpleToolHandler.create((ResourceLocation)JadeIds.JADE((String)"sword"), List.of(TFCItems.ROCK_TOOLS.get((Object)RockCategory.SEDIMENTARY).get((Object)RockCategory.ItemType.KNIFE).asItem())));
    }

    private static void register(String name, RockCategory.ItemType stoneType, Metal.ItemType metalType) {
        HarvestToolProvider.registerHandler((ToolHandler)SimpleToolHandler.create((ResourceLocation)JadeIds.JADE((String)name), List.of(TFCItems.ROCK_TOOLS.get((Object)RockCategory.SEDIMENTARY).get((Object)stoneType).asItem(), JadeIntegration.metalTool(Metal.COPPER, metalType), JadeIntegration.metalTool(Metal.BRONZE, metalType), JadeIntegration.metalTool(Metal.STEEL, metalType), JadeIntegration.metalTool(Metal.BLACK_STEEL, metalType))));
    }

    private static Item metalTool(Metal metal, Metal.ItemType type) {
        return TFCItems.METAL_ITEMS.get(metal).get((Object)type).asItem();
    }

    public void registerClient(IWailaClientRegistration registry) {
        BlockEntityTooltips.register((name, tooltip, block) -> this.register(registry, name, (BlockEntityTooltip)tooltip, block));
        EntityTooltips.register((name, tooltip, entity) -> this.register(registry, name, (EntityTooltip)tooltip, entity));
    }

    private void register(IWailaClientRegistration registry, final ResourceLocation name, final BlockEntityTooltip blockEntityTooltip, Class<? extends Block> block) {
        registry.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor access, IPluginConfig config) {
                blockEntityTooltip.display(access.getLevel(), access.getBlockState(), access.getPosition(), access.getBlockEntity(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            }

            public ResourceLocation getUid() {
                return name;
            }
        }, block);
    }

    private void register(IWailaClientRegistration registry, final ResourceLocation name, final EntityTooltip entityTooltip, Class<? extends Entity> entityClass) {
        registry.registerEntityComponent((IComponentProvider)new IEntityComponentProvider(){

            public void appendTooltip(ITooltip tooltip, EntityAccessor access, IPluginConfig config) {
                entityTooltip.display(access.getLevel(), access.getEntity(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            }

            public ResourceLocation getUid() {
                return name;
            }
        }, entityClass);
    }
}

