/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.AnvilScreen;
import net.dries007.tfc.client.screen.BarrelScreen;
import net.dries007.tfc.client.screen.CalendarScreen;
import net.dries007.tfc.client.screen.ClimateScreen;
import net.dries007.tfc.client.screen.CrucibleScreen;
import net.dries007.tfc.client.screen.FirepitScreen;
import net.dries007.tfc.client.screen.GrillScreen;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.client.screen.NutritionScreen;
import net.dries007.tfc.client.screen.PotScreen;
import net.dries007.tfc.client.screen.SewingTableScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.InstantFluidBarrelRecipe;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.QuernRecipe;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.common.recipes.ingredients.HeatIngredient;
import net.dries007.tfc.compat.jei.TFCCraftingExtensions;
import net.dries007.tfc.compat.jei.TFCInventoryGuiHandler;
import net.dries007.tfc.compat.jei.category.AlloyRecipeCategory;
import net.dries007.tfc.compat.jei.category.AnvilRecipeCategory;
import net.dries007.tfc.compat.jei.category.BlastFurnaceRecipeCategory;
import net.dries007.tfc.compat.jei.category.BloomeryRecipeCategory;
import net.dries007.tfc.compat.jei.category.CastingRecipeCategory;
import net.dries007.tfc.compat.jei.category.ChiselRecipeCategory;
import net.dries007.tfc.compat.jei.category.GlassworkingRecipeCategory;
import net.dries007.tfc.compat.jei.category.HeatingRecipeCategory;
import net.dries007.tfc.compat.jei.category.InstantBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.InstantFluidBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.JamPotRecipeCategory;
import net.dries007.tfc.compat.jei.category.KnappingRecipeCategory;
import net.dries007.tfc.compat.jei.category.LoomRecipeCategory;
import net.dries007.tfc.compat.jei.category.QuernRecipeCategory;
import net.dries007.tfc.compat.jei.category.ScrapingRecipeCategory;
import net.dries007.tfc.compat.jei.category.SealedBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.SewingRecipeCategory;
import net.dries007.tfc.compat.jei.category.SimplePotRecipeCategory;
import net.dries007.tfc.compat.jei.category.SoupPotRecipeCategory;
import net.dries007.tfc.compat.jei.category.WeldingRecipeCategory;
import net.dries007.tfc.compat.jei.transfer.AnvilRecipeTransferHandler;
import net.dries007.tfc.compat.jei.transfer.AnvilRecipeTransferInfo;
import net.dries007.tfc.compat.jei.transfer.BarrelTransferInfo;
import net.dries007.tfc.compat.jei.transfer.FluidIgnoringRecipeTransferHandler;
import net.dries007.tfc.compat.jei.transfer.PotTransferInfo;
import net.dries007.tfc.compat.jei.transfer.WeldingRecipeTransferInfo;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

@JeiPlugin
public final class JEIIntegration
implements IModPlugin {
    public static final IIngredientTypeWithSubtypes<Item, ItemStack> ITEM_STACK = VanillaTypes.ITEM_STACK;
    public static final IIngredientType<FluidStack> FLUID_STACK = NeoForgeTypes.FLUID_STACK;
    public static final RecipeType<HeatingRecipe> HEATING = JEIIntegration.type("heating", HeatingRecipe.class);
    public static final RecipeType<ScrapingRecipe> SCRAPING = JEIIntegration.type("scraping", ScrapingRecipe.class);
    public static final RecipeType<QuernRecipe> QUERN = JEIIntegration.type("quern", QuernRecipe.class);
    public static final RecipeType<PotRecipe> SOUP_POT = JEIIntegration.type("soup_pot", PotRecipe.class);
    public static final RecipeType<PotRecipe> SIMPLE_POT = JEIIntegration.type("simple_pot", PotRecipe.class);
    public static final RecipeType<PotRecipe> JAM_POT = JEIIntegration.type("jam_pot", PotRecipe.class);
    public static final RecipeType<CastingRecipe> CASTING = JEIIntegration.type("casting", CastingRecipe.class);
    public static final RecipeType<LoomRecipe> LOOM = JEIIntegration.type("loom", LoomRecipe.class);
    public static final RecipeType<AlloyRecipe> ALLOYING = JEIIntegration.type("alloying", AlloyRecipe.class);
    public static final RecipeType<SealedBarrelRecipe> SEALED_BARREL = JEIIntegration.type("sealed_barrel", SealedBarrelRecipe.class);
    public static final RecipeType<InstantBarrelRecipe> INSTANT_BARREL = JEIIntegration.type("instant_barrel", InstantBarrelRecipe.class);
    public static final RecipeType<InstantFluidBarrelRecipe> INSTANT_FLUID_BARREL = JEIIntegration.type("instant_fluid_barrel", InstantFluidBarrelRecipe.class);
    public static final RecipeType<BloomeryRecipe> BLOOMERY = JEIIntegration.type("bloomery", BloomeryRecipe.class);
    public static final RecipeType<WeldingRecipe> WELDING = JEIIntegration.type("welding", WeldingRecipe.class);
    public static final RecipeType<AnvilRecipe> ANVIL = JEIIntegration.type("anvil", AnvilRecipe.class);
    public static final RecipeType<ChiselRecipe> CHISEL = JEIIntegration.type("chisel", ChiselRecipe.class);
    public static final RecipeType<GlassworkingRecipe> GLASSWORKING = JEIIntegration.type("glassworking", GlassworkingRecipe.class);
    public static final RecipeType<BlastFurnaceRecipe> BLAST_FURNACE = JEIIntegration.type("blast_furnace", BlastFurnaceRecipe.class);
    public static final RecipeType<SewingRecipe> SEWING = JEIIntegration.type("sewing", SewingRecipe.class);
    private static final Map<KnappingType, RecipeType<KnappingRecipe>> KNAPPING_TYPES = new HashMap<KnappingType, RecipeType<KnappingRecipe>>();

    public static RecipeType<KnappingRecipe> getKnappingType(Map.Entry<ResourceLocation, KnappingType> entry) {
        return KNAPPING_TYPES.computeIfAbsent(entry.getValue(), key -> JEIIntegration.type(((ResourceLocation)entry.getKey()).getPath() + "_knapping", KnappingRecipe.class));
    }

    private static <T> RecipeType<T> type(String name, Class<T> clazz) {
        return RecipeType.create((String)"tfc", (String)name, clazz);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> List<T> recipes(Supplier<net.minecraft.world.item.crafting.RecipeType<T>> type) {
        return JEIIntegration.recipes(type, e -> true);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> List<T> recipes(Supplier<net.minecraft.world.item.crafting.RecipeType<T>> type, Predicate<T> filter) {
        return ClientHelpers.getLevelOrThrow().getRecipeManager().getAllRecipesFor(type.get()).stream().map(RecipeHolder::value).filter(filter).toList();
    }

    private static void addRecipeCatalyst(IRecipeCatalystRegistration registry, TagKey<Item> tag, RecipeType<?> recipeType) {
        Helpers.allItems(tag).forEach(item -> registry.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{recipeType}));
    }

    private static void addRecipeCatalyst(IRecipeCatalystRegistration registry, Wood.BlockType wood, RecipeType<?> recipeType) {
        TFCBlocks.WOODS.values().stream().map(map -> (TFCBlocks.Id)map.get((Object)wood)).forEach(item -> registry.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{recipeType}));
    }

    public ResourceLocation getPluginUid() {
        return Helpers.identifier("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper gui = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new HeatingRecipeCategory(HEATING, gui), new QuernRecipeCategory(QUERN, gui), new ScrapingRecipeCategory(SCRAPING, gui), new SoupPotRecipeCategory(SOUP_POT, gui), new SimplePotRecipeCategory(SIMPLE_POT, gui), new JamPotRecipeCategory(JAM_POT, gui), new CastingRecipeCategory(CASTING, gui), new LoomRecipeCategory(LOOM, gui), new AlloyRecipeCategory(ALLOYING, gui), new SealedBarrelRecipeCategory(SEALED_BARREL, gui), new InstantBarrelRecipeCategory(INSTANT_BARREL, gui), new InstantFluidBarrelRecipeCategory(INSTANT_FLUID_BARREL, gui), new BloomeryRecipeCategory(BLOOMERY, gui), new WeldingRecipeCategory(WELDING, gui), new AnvilRecipeCategory(ANVIL, gui), new ChiselRecipeCategory(CHISEL, gui), new GlassworkingRecipeCategory(GLASSWORKING, gui), new BlastFurnaceRecipeCategory(BLAST_FURNACE, gui), new SewingRecipeCategory(SEWING, gui)});
        for (Map.Entry<ResourceLocation, KnappingType> entry : KnappingType.MANAGER.getElements().entrySet()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new KnappingRecipeCategory<KnappingRecipe>(JEIIntegration.getKnappingType(entry), gui, entry.getValue())});
        }
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(HEATING, JEIIntegration.recipes(TFCRecipeTypes.HEATING));
        registry.addRecipes(SCRAPING, JEIIntegration.recipes(TFCRecipeTypes.SCRAPING));
        registry.addRecipes(QUERN, JEIIntegration.recipes(TFCRecipeTypes.QUERN));
        registry.addRecipes(SOUP_POT, JEIIntegration.recipes(TFCRecipeTypes.POT, recipe -> recipe.getSerializer() == TFCRecipeSerializers.POT_SOUP.get()));
        registry.addRecipes(SIMPLE_POT, JEIIntegration.recipes(TFCRecipeTypes.POT, recipe -> recipe.getSerializer() == TFCRecipeSerializers.POT_SIMPLE.get()));
        registry.addRecipes(JAM_POT, JEIIntegration.recipes(TFCRecipeTypes.POT, recipe -> recipe.getSerializer() == TFCRecipeSerializers.POT_JAM.get()));
        registry.addRecipes(CASTING, JEIIntegration.recipes(TFCRecipeTypes.CASTING));
        registry.addRecipes(LOOM, JEIIntegration.recipes(TFCRecipeTypes.LOOM));
        registry.addRecipes(ALLOYING, JEIIntegration.recipes(TFCRecipeTypes.ALLOY));
        registry.addRecipes(SEALED_BARREL, JEIIntegration.recipes(TFCRecipeTypes.BARREL_SEALED));
        registry.addRecipes(INSTANT_BARREL, JEIIntegration.recipes(TFCRecipeTypes.BARREL_INSTANT, recipe -> !(recipe.getInputItem().ingredient().getCustomIngredient() instanceof HeatIngredient)));
        registry.addRecipes(INSTANT_FLUID_BARREL, JEIIntegration.recipes(TFCRecipeTypes.BARREL_INSTANT_FLUID));
        registry.addRecipes(BLOOMERY, JEIIntegration.recipes(TFCRecipeTypes.BLOOMERY));
        registry.addRecipes(WELDING, JEIIntegration.recipes(TFCRecipeTypes.WELDING));
        registry.addRecipes(ANVIL, JEIIntegration.recipes(TFCRecipeTypes.ANVIL));
        registry.addRecipes(CHISEL, JEIIntegration.recipes(TFCRecipeTypes.CHISEL));
        registry.addRecipes(GLASSWORKING, JEIIntegration.recipes(TFCRecipeTypes.GLASSWORKING));
        registry.addRecipes(BLAST_FURNACE, JEIIntegration.recipes(TFCRecipeTypes.BLAST_FURNACE));
        registry.addRecipes(SEWING, JEIIntegration.recipes(TFCRecipeTypes.SEWING));
        KNAPPING_TYPES.forEach((knappingType, recipeType) -> registry.addRecipes(recipeType, JEIIntegration.recipes(TFCRecipeTypes.KNAPPING, r -> r.knappingType().get().equals(knappingType))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.FIREPIT.get()), new RecipeType[]{HEATING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.QUERN.get()), new RecipeType[]{QUERN});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{SIMPLE_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.CERAMIC_BOWL.get()), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Items.BOWL), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{JAM_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.EMPTY_JAR_WITH_LID), new RecipeType[]{JAM_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.CRUCIBLE.get()), new RecipeType[]{ALLOYING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.VESSEL.get()), new RecipeType[]{ALLOYING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.BLOOMERY.get()), new RecipeType[]{BLOOMERY});
        registry.addRecipeCatalyst(new ItemStack(TFCBlocks.BLAST_FURNACE), new RecipeType[]{BLAST_FURNACE});
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.SEWING_NEEDLES, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.SEWING_DARK_CLOTH, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.SEWING_LIGHT_CLOTH, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.SEWING_TABLE, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.BLOWPIPES, GLASSWORKING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.BLAST_FURNACE_TUYERES, BLAST_FURNACE);
        for (TFCItems.ItemId itemId : TFCItems.GLAZED_VESSELS.values()) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)itemId), new RecipeType[]{ALLOYING});
        }
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.TOOLS_KNIFE, SCRAPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.QUERN_HANDSTONES, QUERN);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ANVILS, WELDING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ANVILS, ANVIL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.LOOM, LOOM);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, SEALED_BARREL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, INSTANT_BARREL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, INSTANT_FLUID_BARREL);
        for (Map.Entry entry : KnappingType.MANAGER.getElements().entrySet()) {
            RecipeType<KnappingRecipe> recipeType = JEIIntegration.getKnappingType(entry);
            for (ItemStack item : ((KnappingType)entry.getValue()).inputItem().ingredient().getItems()) {
                registry.addRecipeCatalyst(item, new RecipeType[]{recipeType});
            }
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(KnappingScreen.class, 97, 44, 22, 15, (RecipeType[])KNAPPING_TYPES.values().toArray(RecipeType[]::new));
        registry.addRecipeClickArea(AnvilScreen.class, 26, 24, 9, 14, new RecipeType[]{ANVIL, WELDING});
        registry.addRecipeClickArea(BarrelScreen.class, 92, 21, 9, 14, new RecipeType[]{SEALED_BARREL, INSTANT_BARREL, INSTANT_FLUID_BARREL});
        registry.addRecipeClickArea(CrucibleScreen.class, 82, 100, 10, 15, new RecipeType[]{HEATING});
        registry.addRecipeClickArea(CrucibleScreen.class, 139, 100, 10, 15, new RecipeType[]{ALLOYING, CASTING});
        registry.addRecipeClickArea(FirepitScreen.class, 79, 46, 18, 10, new RecipeType[]{HEATING});
        registry.addRecipeClickArea(GrillScreen.class, 61, 37, 18, 10, new RecipeType[]{HEATING});
        registry.addRecipeClickArea(PotScreen.class, 77, 6, 9, 14, new RecipeType[]{SIMPLE_POT, SOUP_POT, JAM_POT});
        registry.addRecipeClickArea(SewingTableScreen.class, 125, 84, 22, 15, new RecipeType[]{SEWING});
        registry.addGuiContainerHandler(InventoryScreen.class, new TFCInventoryGuiHandler());
        registry.addGuiContainerHandler(CalendarScreen.class, new TFCInventoryGuiHandler());
        registry.addGuiContainerHandler(ClimateScreen.class, new TFCInventoryGuiHandler());
        registry.addGuiContainerHandler(NutritionScreen.class, new TFCInventoryGuiHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        IRecipeTransferHandlerHelper transferHelper = registry.getTransferHelper();
        registry.addRecipeTransferHandler(FirepitContainer.class, (MenuType)TFCContainerTypes.FIREPIT.get(), HEATING, 4, 1, 7, 36);
        registry.addRecipeTransferHandler(GrillContainer.class, (MenuType)TFCContainerTypes.GRILL.get(), HEATING, 4, 5, 9, 36);
        registry.addRecipeTransferHandler(CrucibleContainer.class, (MenuType)TFCContainerTypes.CRUCIBLE.get(), HEATING, 0, 9, 10, 36);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler(transferHelper.createBasicRecipeTransferInfo(CrucibleContainer.class, (MenuType)TFCContainerTypes.CRUCIBLE.get(), CASTING, 9, 1, 10, 36))), CASTING);
        registry.addRecipeTransferHandler((IRecipeTransferInfo)new WeldingRecipeTransferInfo(transferHelper));
        registry.addRecipeTransferHandler(new AnvilRecipeTransferHandler(transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new AnvilRecipeTransferInfo(transferHelper))), ANVIL);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new PotTransferInfo(transferHelper, SIMPLE_POT))), SIMPLE_POT);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new PotTransferInfo(transferHelper, SOUP_POT))), SOUP_POT);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new PotTransferInfo(transferHelper, JAM_POT))), JAM_POT);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler(new BarrelTransferInfo<SealedBarrelRecipe>(SEALED_BARREL))), SEALED_BARREL);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registry) {
        TFCCraftingExtensions.register(registry);
    }
}

