/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.util.AlloyRange;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class AlloyRecipeCategory
extends BaseRecipeCategory<AlloyRecipe> {
    private static final int MAX_HEIGHT = 82;
    private static final int FIRST_COLUMN_X = 4;
    private static final int SECOND_COLUMN_X = 70;

    public AlloyRecipeCategory(RecipeType<AlloyRecipe> type, IGuiHelper helper) {
        super(type, helper, 170, 82, new ItemStack((ItemLike)TFCBlocks.CRUCIBLE.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder fluidOutput = builder.addSlot(RecipeIngredientRole.OUTPUT, 149, 41 - this.slot.getHeight() / 2 + 1);
        int[] positions = this.getPositions(recipe.contents().size());
        int iteration = 0;
        for (AlloyRange range : recipe.contents()) {
            int x = (iteration % 2 == 0 ? 4 : 70) + 1;
            int y = positions[Math.floorDiv(iteration, 2)] + 1;
            IRecipeSlotBuilder liquidSlot = builder.addSlot(RecipeIngredientRole.INPUT, x, y);
            liquidSlot.addIngredient(JEIIntegration.FLUID_STACK, (Object)new FluidStack(range.fluid(), 1000));
            liquidSlot.setBackground((IDrawable)this.slot, -1, -1);
            ++iteration;
        }
        fluidOutput.addIngredient(JEIIntegration.FLUID_STACK, (Object)new FluidStack(recipe.result(), 1000));
        fluidOutput.setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(AlloyRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics graphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int[] positions = this.getPositions(recipe.contents().size());
        int iteration = 0;
        for (AlloyRange range : recipe.contents()) {
            int x = (iteration % 2 == 0 ? 4 : 70) + this.slot.getWidth() + 2;
            int n = positions[Math.floorDiv(iteration, 2)] + this.slot.getHeight() / 2;
            Objects.requireNonNull(font);
            int y = n - Math.floorDiv(9, 2);
            graphics.drawString(font, (Component)Component.literal((String)this.formatRange(range)).withStyle(ChatFormatting.BLACK), x, y, 0xFFFFFF, false);
            ++iteration;
        }
        this.fire.draw(graphics, 130, 41 - this.fire.getHeight() / 2);
        this.fireAnimated.draw(graphics, 130, 41 - this.fireAnimated.getHeight() / 2);
    }

    protected int[] getPositions(int rangesSize) {
        int rows = (int)Math.ceil((double)rangesSize / 2.0);
        int spacing = 2;
        int[] positions = new int[rows];
        int totalHeight = this.slot.getHeight() * rows + spacing * (rows - 1);
        int currentHeight = (82 - totalHeight) / 2;
        for (int i = 0; i < rows; ++i) {
            positions[i] = currentHeight;
            currentHeight += this.slot.getHeight() + spacing;
        }
        return positions;
    }

    protected String formatRange(AlloyRange range) {
        if (Math.abs(range.max() - range.min()) < 4.656612875245797E-10) {
            return String.format("%.0f%%", range.max() * 100.0);
        }
        return String.format("%.0f-%.0f%%", range.min() * 100.0, range.max() * 100.0);
    }
}

