/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AnvilRecipeCategory
extends BaseRecipeCategory<AnvilRecipe> {
    public AnvilRecipeCategory(RecipeType<AnvilRecipe> type, IGuiHelper helper) {
        super(type, helper, 98, 26, new ItemStack((ItemLike)TFCBlocks.METALS.get(Metal.BRONZE).get((Object)Metal.BlockType.ANVIL).get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AnvilRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 6, 5);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 5);
        inputSlot.addIngredients(recipe.getInput());
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        outputSlot.addItemStack(recipe.getResultItem((HolderLookup.Provider)AnvilRecipeCategory.registryAccess()));
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
        outputSlot.addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"tfc.tooltip.anvil_tier_required", (Object[])new Object[]{Tooltips.tier(recipe.getMinTier())})));
    }

    public void draw(AnvilRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 36, 5);
        this.arrowAnimated.draw(stack, 36, 5);
    }
}

