/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public abstract class BaseRecipeCategory<T>
extends AbstractRecipeCategory<T> {
    public static final ResourceLocation ICONS = Helpers.identifier("textures/gui/jei/icons.png");
    protected final IDrawableStatic slot;
    protected final IDrawableStatic fire;
    protected final IDrawableAnimated fireAnimated;
    protected final IDrawableStatic arrow;
    protected final IDrawableAnimated arrowAnimated;

    public static RegistryAccess registryAccess() {
        return ClientHelpers.getLevelOrThrow().registryAccess();
    }

    public static List<FluidStack> collapse(SizedFluidIngredient ingredient) {
        return Arrays.asList(ingredient.getFluids());
    }

    public static List<ItemStack> collapse(SizedIngredient input) {
        return Arrays.stream(input.ingredient().getItems()).map(stack -> FoodCapability.setTransientNonDecaying(stack.copyWithCount(input.count()))).toList();
    }

    public static List<ItemStack> collapse(ItemStackProvider output) {
        return List.of(output.getEmptyStack());
    }

    public static List<ItemStack> collapse(List<ItemStack> inputs, ItemStackProvider output) {
        if (inputs.isEmpty()) {
            return List.of(output.getEmptyStack());
        }
        return inputs.stream().map(output::getStack).map(FoodCapability::setTransientNonDecaying).toList();
    }

    public static Ingredient collapse(BlockIngredient ingredient) {
        return Ingredient.of(ingredient.all().map(ItemStack::new).filter(item -> !item.isEmpty()));
    }

    public BaseRecipeCategory(RecipeType<T> type, IGuiHelper helper, int width, int height, ItemStack icon) {
        super(type, (Component)Component.translatable((String)("tfc.jei." + type.getUid().getPath())), helper.createDrawableIngredient(JEIIntegration.ITEM_STACK, (Object)FoodCapability.setNonDecaying(icon)), width, height);
        this.slot = helper.getSlotDrawable();
        this.fire = helper.createDrawable(ICONS, 0, 0, 14, 14);
        IDrawableStatic fireAnimated = helper.createDrawable(ICONS, 14, 0, 14, 14);
        this.fireAnimated = helper.createAnimatedDrawable(fireAnimated, 160, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.createDrawable(ICONS, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(ICONS, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 80, IDrawableAnimated.StartDirection.LEFT, false);
    }
}

