/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.ArrayList;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class CastingRecipeCategory
extends BaseRecipeCategory<CastingRecipe> {
    private static final String INPUT_SLOT = "input";

    public CastingRecipeCategory(RecipeType<CastingRecipe> type, IGuiHelper helper) {
        super(type, helper, 98, 26, new ItemStack((ItemLike)TFCItems.MOLDS.get((Object)Metal.ItemType.INGOT).get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CastingRecipe recipe, IFocusGroup focuses) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack input : recipe.getIngredient().getItems()) {
            for (FluidStack fluid : recipe.getFluidIngredient().getFluids()) {
                ItemStack filled = input.copy();
                @Nullable IFluidHandler fluidHandler = (IFluidHandler)filled.getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidHandler == null) continue;
                fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                inputs.add(filled);
            }
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).addItemStacks(inputs)).setSlotName(INPUT_SLOT).setBackground((IDrawable)this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 5).addIngredients(JEIIntegration.FLUID_STACK, CastingRecipeCategory.collapse(recipe.getFluidIngredient()))).setFluidRenderer(1L, false, 16, 16).setBackground((IDrawable)this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 5).addItemStack(recipe.getResultItem((HolderLookup.Provider)CastingRecipeCategory.registryAccess()))).setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(CastingRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        recipeSlots.findSlotByName(INPUT_SLOT).flatMap(IRecipeSlotView::getDisplayedItemStack).ifPresent(filled -> HeatCapability.setTemperature(filled, Heat.maxVisibleTemperature()));
        this.arrow.draw(stack, 48, 5);
        this.arrowAnimated.draw(stack, 48, 5);
    }
}

