/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.OpenFieldGuidePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2ic;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;

public final class PatchouliClientEventHandler {
    private static float lexiconLookupTime = 0.0f;
    private static final int backgroundLength = 28;
    private static final int backgroundHeight = 34;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(PatchouliClientEventHandler::renderBookTooltipWithoutBook);
    }

    public static void renderBookTooltipWithoutBook(RenderTooltipEvent.Pre event) {
        if (!TFCConfig.CLIENT.showGuideBookLinksAlways.get().booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        GuiGraphics graphics = event.getGraphics();
        ItemStack stack = event.getItemStack();
        int tooltipX = event.getX();
        int tooltipY = event.getY();
        if (PatchouliClientEventHandler.wouldPatchouliRenderATooltipHere(minecraft, stack)) {
            return;
        }
        Book book = (Book)BookRegistry.INSTANCE.books.get(PatchouliIntegration.BOOK_ID);
        Pair entry = book.getContents().getEntryForStack(stack);
        if (entry != null && !((BookEntry)entry.getFirst()).isLocked()) {
            ItemStack bookStack = ItemModBook.forBook((Book)book);
            int x = tooltipX - 34;
            int y = tooltipY - 4;
            int itemTooltipLength = 0;
            int itemTooltipHeight = 0;
            for (ClientTooltipComponent component : event.getComponents()) {
                itemTooltipLength = Integer.max(itemTooltipLength, component.getWidth(event.getFont()));
                itemTooltipHeight += component.getHeight();
            }
            Vector2ic itemTooltipPos = event.getTooltipPositioner().positionTooltip(event.getScreenWidth(), event.getScreenHeight(), tooltipX, tooltipY, itemTooltipLength, itemTooltipHeight);
            int itemTooltipX = itemTooltipPos.x();
            int itemTooltipY = itemTooltipPos.y();
            if (itemTooltipX < tooltipX) {
                x = tooltipX + 18;
            }
            if (x + 28 > event.getScreenWidth()) {
                x = itemTooltipX + itemTooltipLength - 28;
                y = itemTooltipY - 34 - 8;
            } else if (x - 8 < 0) {
                x = itemTooltipX;
                y = itemTooltipY - 34 - 8;
            }
            if (y < 0) {
                y = itemTooltipY + itemTooltipHeight + 20;
            }
            RenderSystem.disableDepthTest();
            graphics.fill(x - 4, y - 4, x + 20, y + 26, 0x44000000);
            graphics.fill(x - 6, y - 6, x + 22, y + 28, 0x44000000);
            if (PatchouliConfig.get().useShiftForQuickLookup() ? Screen.hasShiftDown() : Screen.hasControlDown()) {
                int cx = x + 8;
                int cy = y + 8;
                float r = 12.0f;
                float time = 20.0f;
                float angles = (lexiconLookupTime += ClientTicker.delta) / time * 360.0f;
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                float a = 0.5f + 0.2f * ((float)Math.cos(ClientTicker.total / 10.0f) * 0.5f + 0.5f);
                buf.addVertex((float)cx, (float)cy, 0.0f).setColor(0.0f, 0.5f, 0.0f, a);
                for (float i = angles; i > 0.0f; i -= 1.0f) {
                    float rad = (i - 90.0f) / 180.0f * (float)Math.PI;
                    buf.addVertex((float)cx + Mth.cos((float)rad) * r, (float)cy + Mth.sin((float)rad) * r, 0.0f).setColor(0.0f, 1.0f, 0.0f, 1.0f);
                }
                buf.addVertex((float)cx, (float)cy, 0.0f).setColor(0.0f, 1.0f, 0.0f, 0.0f);
                BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
                RenderSystem.disableBlend();
                if (lexiconLookupTime >= time) {
                    int spread = (Integer)entry.getSecond();
                    PacketDistributor.sendToServer((CustomPacketPayload)new OpenFieldGuidePacket(((BookEntry)entry.getFirst()).getId(), spread * 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                lexiconLookupTime = 0.0f;
            }
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 300.0f);
            graphics.renderItem(bookStack, x, y);
            graphics.renderItemDecorations(minecraft.font, bookStack, x, y);
            graphics.pose().popPose();
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 500.0f);
            graphics.drawString(minecraft.font, "?", x + 10, y + 8, -1, true);
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            boolean mac = Minecraft.ON_OSX;
            MutableComponent key = Component.literal((String)(PatchouliConfig.get().useShiftForQuickLookup() ? "Shift" : (mac ? "Cmd" : "Ctrl"))).withStyle(ChatFormatting.BOLD);
            graphics.drawString(minecraft.font, (Component)key, (x + 10) * 2 - 16, (y + 8) * 2 + 20, -1, true);
            graphics.pose().popPose();
            RenderSystem.enableDepthTest();
        } else {
            lexiconLookupTime = 0.0f;
        }
    }

    private static boolean wouldPatchouliRenderATooltipHere(Minecraft minecraft, ItemStack stack) {
        if (minecraft.player != null && !(minecraft.screen instanceof GuiBook)) {
            for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
                Pair entry;
                Book book;
                ItemStack stackAt = minecraft.player.getInventory().getItem(i);
                if (stackAt.isEmpty() || (book = ItemStackUtil.getBookFromStack((ItemStack)stackAt)) == null || (entry = book.getContents().getEntryForStack(stack)) == null || ((BookEntry)entry.getFirst()).isLocked()) continue;
                return true;
            }
        }
        return false;
    }
}

